% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{diameter}
\alias{diameter}
\alias{get_diameter}
\alias{farthest_vertices}
\title{Diameter of a graph}
\usage{
diameter(graph, directed = TRUE, unconnected = TRUE, weights = NULL)

get_diameter(graph, directed = TRUE, unconnected = TRUE, weights = NULL)

farthest_vertices(graph, directed = TRUE, unconnected = TRUE, weights = NULL)
}
\arguments{
\item{graph}{The graph to analyze.}

\item{directed}{Logical, whether directed or undirected paths are to be
considered. This is ignored for undirected graphs.}

\item{unconnected}{Logical, what to do if the graph is unconnected. If
FALSE, the function will return a number that is one larger the largest
possible diameter, which is always the number of vertices. If TRUE, the
diameters of the connected components will be calculated and the largest one
will be returned.}

\item{weights}{Optional positive weight vector for calculating weighted
distances. If the graph has a \code{weight} edge attribute, then this is
used by default.}
}
\value{
A numeric constant for \code{diameter()}, a numeric vector for
\code{get_diameter()}. \code{farthest_vertices()} returns a list with two
entries: \itemize{
\item \code{vertices} The two vertices that are the farthest.
\item \code{distance} Their distance.
}
}
\description{
The diameter of a graph is the length of the longest geodesic.
}
\details{
The diameter is calculated by using a breadth-first search like method.

\code{get_diameter()} returns a path with the actual diameter. If there are
many shortest paths of the length of the diameter, then it returns the first
one found.

\code{farthest_vertices()} returns two vertex ids, the vertices which are
connected by the diameter path.
}
\examples{

g <- make_ring(10)
g2 <- delete_edges(g, c(1, 2, 1, 10))
diameter(g2, unconnected = TRUE)
diameter(g2, unconnected = FALSE)

## Weighted diameter
set.seed(1)
g <- make_ring(10)
E(g)$weight <- sample(seq_len(ecount(g)))
diameter(g)
get_diameter(g)
diameter(g, weights = NA)
get_diameter(g, weights = NA)

}
\seealso{
\code{\link[=distances]{distances()}}

Other paths: 
\code{\link{all_simple_paths}()},
\code{\link{distance_table}()},
\code{\link{eccentricity}()},
\code{\link{radius}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{paths}
\keyword{graphs}
