% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralization.R
\name{centr_eigen}
\alias{centr_eigen}
\alias{centralization.evcent}
\title{Centralize a graph according to the eigenvector centrality of vertices}
\usage{
centr_eigen(
  graph,
  directed = FALSE,
  scale = TRUE,
  options = arpack_defaults,
  normalized = TRUE
)
}
\arguments{
\item{graph}{The input graph.}

\item{directed}{logical scalar, whether to use directed shortest paths for
calculating eigenvector centrality.}

\item{scale}{Whether to rescale the eigenvector centrality scores, such that
the maximum score is one.}

\item{options}{This is passed to \code{\link[=eigen_centrality]{eigen_centrality()}}, the options
for the ARPACK eigensolver.}

\item{normalized}{Logical scalar. Whether to normalize the graph level
centrality score by dividing by the theoretical maximum.}
}
\value{
A named list with the following components:
\item{vector}{The node-level centrality scores.}
\item{value}{The corresponding eigenvalue.}
\item{options}{ARPACK options, see the return value of
\code{\link[=eigen_centrality]{eigen_centrality()}} for details.}
\item{centralization}{The graph level centrality index.}
\item{theoretical_max}{The same as above, the theoretical maximum
centralization score for a graph with the same number of vertices.}
}
\description{
See \code{\link[=centralize]{centralize()}} for a summary of graph centralization.
}
\examples{
# A BA graph is quite centralized
g <- sample_pa(1000, m = 4)
centr_degree(g)$centralization
centr_clo(g, mode = "all")$centralization
centr_betw(g, directed = FALSE)$centralization
centr_eigen(g, directed = FALSE)$centralization

# The most centralized graph according to eigenvector centrality
g0 <- make_graph(c(2, 1), n = 10, dir = FALSE)
g1 <- make_star(10, mode = "undirected")
centr_eigen(g0)$centralization
centr_eigen(g1)$centralization
}
\seealso{
Other centralization related: 
\code{\link{centr_betw_tmax}()},
\code{\link{centr_betw}()},
\code{\link{centr_clo_tmax}()},
\code{\link{centr_clo}()},
\code{\link{centr_degree_tmax}()},
\code{\link{centr_degree}()},
\code{\link{centr_eigen_tmax}()},
\code{\link{centralize}()}
}
\concept{centralization related}
