% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogi.r
\name{cogi}
\alias{cogi}
\title{Calculate Continuous Glucose Monitoring Index (COGI) values}
\usage{
cogi(data, targets = c(70, 180), weights = c(.5,.35,.15))
}
\arguments{
\item{data}{DataFrame with column names ("id", "time", and "gl"),
or numeric vector of glucose values.}

\item{targets}{Numeric vector of two glucose values for threshold. Glucose values from
data argument will be compared to each value in the targets vector to determine the
time in range and time below range for COGI. The lower value will be used for determining
time below range.
Default list is (70, 180).}

\item{weights}{Numeric vector of three weights to be applied to time in range, time below range
and glucose variability, respectively. The default list is (.5,.35,.15)}
}
\value{
If a data.frame object is passed, then a tibble object with
a column for subject id and then a column for each target value is returned. If a vector of glucose
values is passed, then a tibble object without the subject id is returned.
as.numeric() can be wrapped around the latter to output a numeric vector.
}
\description{
The function COGI produces cogi values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
column for each target value is returned. NA's will be omitted from the glucose
values in calculation of cogi.
}
\examples{

data(example_data_1_subject)

cogi(example_data_1_subject)
cogi(example_data_1_subject, targets = c(50, 140), weights = c(.3,.6,.1))

data(example_data_5_subject)

cogi(example_data_5_subject)
cogi(example_data_5_subject, targets = c(80, 180), weights = c(.2,.4,.4))

}
\references{
Leelarathna (2020) Evaluating Glucose Control With a Novel Composite
Continuous Glucose Monitoring Index,
\emph{Diabetes Technology and Therapeutics} \strong{14(2)} 277-284,
\doi{10.1177/1932296819838525}.
}
