# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Select IG copula quantities: matching inputs
#'
#' The density function, 1|2 conditional cdf,
#' and 1|2 conditional quantile function of the IG
#' copula family. Inputs
#' need to be vectors of the same length.
#' These functions are called by the R functions of the
#' same name, without the `_vec` suffix.
#'
#' @param u,v Copula arguments. Vector of values between 0 and 1.
#' @param p Function inverse argument. Vector of values between 0 and 1.
#' @param theta,alpha IG copula parameters. Vector of positive values.
#' @note If calling these functions manually, make sure each input
#' are vectors of a common length.
#' @details The `qcondig12()` function needs its own Newton
#' Raphson algorithm. It also needs access to some version
#' of `pcondig12()` and `dig()`. So, these three functions
#' are coded up in C++, each with a scalar and vector pair
#' of functions.
#' @seealso `dig()`, `pcondig12()`, and `qcondig12()`;
#' and `igl_gen_vec()` and family.
#' @rdname ig_cpp_vec
dig_vec <- function(u, v, theta, alpha) {
    .Call(`_igcop_dig_vec`, u, v, theta, alpha)
}

#' IG/IGL Generators and Related Functions: matching inputs
#'
#' These are the psi, H, and kappa functions
#' of the IG and IGL copula families, but with inputs
#' needing to be vectors of the same length.
#' These functions are called by the R functions of the
#' same name, without the `_vec` suffix.
#' @param x Function argument. Vector of non-negative values.
#' @param p Function inverse argument. Vector of values between 0 and 1.
#' @param eta,alpha Function parameters. Vector of positive values.
#' @note If calling this function manually, make sure each input
#' are vectors of a common length. 
#' @seealso `igl_gen()` and family; 
#' `dig_vec()`, `pcondig12_vec()`, and `qcondig12_vec()`. 
#' @rdname generators_vec
igl_gen_vec <- function(x, alpha) {
    .Call(`_igcop_igl_gen_vec`, x, alpha)
}

#' @rdname generators_vec
igl_gen_D_vec <- function(x, alpha) {
    .Call(`_igcop_igl_gen_D_vec`, x, alpha)
}

#' @rdname generators_vec
igl_gen_inv_vec <- function(p, alpha) {
    .Call(`_igcop_igl_gen_inv_vec`, p, alpha)
}

#' @rdname generators_vec
igl_kappa_vec <- function(x, alpha) {
    .Call(`_igcop_igl_kappa_vec`, x, alpha)
}

#' @rdname generators_vec
igl_kappa_D_vec <- function(x, alpha) {
    .Call(`_igcop_igl_kappa_D_vec`, x, alpha)
}

#' @rdname generators_vec
igl_kappa_inv_vec <- function(p, alpha) {
    .Call(`_igcop_igl_kappa_inv_vec`, p, alpha)
}

#' @rdname generators_vec
interp_gen_vec <- function(x, eta, alpha) {
    .Call(`_igcop_interp_gen_vec`, x, eta, alpha)
}

#' @rdname generators_vec
interp_gen_inv_vec <- function(p, eta, alpha) {
    .Call(`_igcop_interp_gen_inv_vec`, p, eta, alpha)
}

#' @rdname generators_vec
interp_kappa_vec <- function(x, eta, alpha) {
    .Call(`_igcop_interp_kappa_vec`, x, eta, alpha)
}

#' @rdname generators_vec
interp_kappa_inv_vec <- function(p, eta, alpha) {
    .Call(`_igcop_interp_kappa_inv_vec`, p, eta, alpha)
}

#' @rdname ig_cpp_vec
pcondig12_vec <- function(u, v, theta, alpha) {
    .Call(`_igcop_pcondig12_vec`, u, v, theta, alpha)
}

#' @rdname ig_cpp_vec
qcondig12_vec <- function(p, v, theta, alpha) {
    .Call(`_igcop_qcondig12_vec`, p, v, theta, alpha)
}

