% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side.r
\name{side}
\alias{side}
\title{Higher-order Local Information Dimension Estimator.}
\usage{
side(x, maxDim = 5, DM = FALSE, local = FALSE, method = "disc",
  comb = "average")
}
\arguments{
\item{x}{data matrix or distance matrix given by as.matrix(dist(x)).}

\item{maxDim}{maximum of the candidate dimensions.}

\item{DM}{whether \code{'x'} is distance matrix or not. logical.}

\item{local}{logical. If \code{TRUE}, a vector of local dimensions at each sample point is returned.}

\item{method}{algorithm to estimate intrinsic dimension. 'disc' for discrite dimension estimation. 'cont' for continuous dimension estimation with MLE by Newton-method.}

\item{comb}{'average', 'median' or 'vote' for combining local estimates when global estimate is required.}
}
\value{
Estimated local or global intrinsic dimension.
}
\description{
\code{side} is a Higher-order Information Dimension Estimator, which estimates
local information dimension of given dataset based on the polynomial regression
with Poisson error structure.
}
\details{
A variant of fractal dimension called the local information dimension is considered.
The local information dimension is estimated by using the probability mass function.
The function \code{side} considers higher-order expansion of the probability mass around
the inspection point, and it estimates the local information dimension by fitting 
a generalized linear model with Poisson error structure and an identity link function.
There are two methods for dimension estimation: the first method tries different 
dimensions and adopt the one with maximum likelihood, while the second method directly
maximises the likelihood with respect to the intrinsic dimension. The former returns 
an integer-valued dimension estimate, and the latter returns a real-valued estimate.
The result of the former method is used as an initial value for the latter method
in numerical optimization. Slow but more accurate than \code{mada} in some cases.
}
\examples{
## local intrinsic dimension estimate
tmp <- gendata(DataName='ldbl', n=300)
x <- tmp$x
set.seed(999)
idx <- c(sample(which(tmp$tDim==1)[1:10],3), sample(which(tmp$tDim==2)[1:30],3))
estmada <- mada(x=x[1:100,], local=TRUE)
estmada[idx]  ## estimated local intrinsic dimensions by mada
tmp$tDim[idx] ## true local intrinsic dimensions
estside <- side(x=x[1:100,], local=TRUE)
estside[idx] ## estimated local intrinsic dimensions by side
}
\references{
H. Hino, J. Fujiki, S. Akaho, and N. Murata, 'Local Intrinsic Dimension Estimation by Generalized Linear Modeling', Neural Computation, 2017
}
\author{
Hideitsu Hino \email{hideitsu.hino@gmail.com}
}
