% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoom.R
\name{zoom}
\alias{zoom}
\title{Zoom}
\usage{
zoom(obj, cex = 1.8, cex.main = 1.3 * cex, cex.lab = 1.1 * cex,
  cex.axis = cex, cex.strip = cex, cex.symbol = cex, cex.sub = 0.7
  * cex, cex.legend = 0.7 * cex)
}
\arguments{
\item{obj}{a lattice plot of class \code{"trellis"}.}

\item{cex}{text size multiplier.}

\item{cex.main}{size of main title (default is \code{1.3 * cex}).}

\item{cex.lab}{size of axis labels (default is \code{1.1 * cex}).}

\item{cex.axis}{size of tick labels (default is \code{cex}).}

\item{cex.strip}{size of strip labels (default is \code{cex}).}

\item{cex.symbol}{size of text inside plot (default is \code{cex}).}

\item{cex.sub}{size of subtitle (default is \code{0.7 * cex}).}

\item{cex.legend}{size of legend labels (default is \code{0.7 * cex}).}
}
\value{
The same lattice object, but with altered text size.
}
\description{
Change text size in a lattice plot.
}
\note{
The default values result in lattice plots that have similar text size as
base plots, when using \code{taf.png}.

This function ends with a \code{\link[=print.trellis]{print}} call, to make
it easy to export the lattice plot to a file, without the need of an explicit
\code{print}.
}
\examples{
library(lattice)

xyplot(1~1)
zoom(xyplot(1~1))
zoom(xyplot(1~1), cex=1)

\dontrun{
taf.png("myplot")
plot(1)
dev.off()

taf.png("mytrellis")
zoom(xyplot(1~1))
dev.off()
}

}
\seealso{
\code{\link{Lattice}} plots are created using \code{\link{xyplot}} or related
functions.

\code{\link{taf.png}} opens a PNG graphics device.

\code{\link{icesTAF-package}} gives an overview of the package.
}
