% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIndices.R
\name{getIndices}
\alias{getIndices}
\title{Get Survey Indices}
\usage{
getIndices(survey, year, quarter, species)
}
\arguments{
\item{survey}{the survey acronym, e.g. NS-IBTS.}

\item{year}{the year of the survey, e.g. 2010.}

\item{quarter}{the quarter of the year the survey took place, i.e. 1, 2, 3 or 4.}

\item{species}{the aphia species code for the species of interest.}
}
\value{
A data frame.
}
\description{
Get age based indices of abundance by species, survey and year.
}
\note{
The \pkg{icesAdvice} package provides \code{findAphia}, a function to look up Aphia species codes.
}
\examples{
\dontrun{
haddock_aphia <- icesVocab::findAphia("haddock")
index <- getIndices(survey = "NS-IBTS", year = 2002, quarter = 3, species = haddock_aphia)
str(index)
}
}
\seealso{
\code{\link{getDATRAS}} supports querying many years and quarters in one function call.

\code{\link{getHHdata}} and \code{\link{getCAdata}} get haul data and
age-based data.

\code{\link{icesDatras-package}} gives an overview of the package.
}
