% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFlexFile.R
\name{getFlexFile}
\alias{getFlexFile}
\title{Get Flex File}
\usage{
getFlexFile(survey, year, quarter)
}
\arguments{
\item{survey}{the survey acronym, e.g. NS-IBTS.}

\item{year}{the year of the survey, e.g. 2010.}

\item{quarter}{the quarter of the year the survey took place, i.e. 1, 2, 3 or 4.}
}
\value{
A data frame.
}
\description{
Get all information in HH plus estimates of Door Spread, Wing Spread and
Swept Area per square km. Only available for NS-IBTS survey.
}
\examples{
\dontrun{
flex <- getFlexFile(survey = "ROCKALL", year = 2002, quarter = 3)
str(flex)

# error checking examples:
flex <- getFlexFile(survey = "NS_IBTS", year = 2016, quarter = 1)
flex <- getFlexFile(survey = "NS-IBTS", year = 2030, quarter = 1)
flex <- getFlexFile(survey = "NS-IBTS", year = 2016, quarter = 6)
}
}
\seealso{
\code{\link{getDATRAS}} supports querying many years and quarters in one function call.

\code{\link{getHHdata}} get haul data

\code{\link{icesDatras-package}} gives an overview of the package.
}
\author{
Adriana Villamor.
}
