% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCatchWgt.R
\name{getCatchWgt}
\alias{getCatchWgt}
\title{Get Catch Weights}
\usage{
getCatchWgt(survey, years, quarters, aphia)
}
\arguments{
\item{survey}{the survey acronym e.g. NS-IBTS.}

\item{years}{a vector of years of the survey, e.g. c(2010, 2012) or 2005:2010.}

\item{quarters}{a vector of quarters of the year the survey took place, e.g. c(1, 4) or 1:4.}

\item{aphia}{a vector of Aphia species codes defined in the WoRMS database, e.g. c(126436, 1264374).}
}
\value{
A data frame.
}
\description{
Get the reported catch weight by species and haul.
}
\note{
The \pkg{icesVocab} package provides \code{findAphia}, a function to look up Aphia species codes.
}
\examples{
\dontrun{
getCatchWgt(survey = "ROCKALL", years = 2002, quarters = 3, aphia = 126437)

# look up specific species
aphia <- icesVocab::findAphia(c("cod", "haddock"))
cwt <- getCatchWgt(survey = "ROCKALL", years = 2002, quarters = 3, aphia = aphia)
}
}
\seealso{
\code{\link{getSurveyYearList}}, \code{\link{getSurveyYearQuarterList}}, and
\code{\link{getDatrasDataOverview}} also list available data.

\code{\link{icesDatras-package}} gives an overview of the package.
}
