% Generated by roxygen2 (4.0.1): do not edit by hand
\name{stopIfInvalidIcd9}
\alias{stopIfInvalidIcd9}
\alias{warnIfInvalidIcd9}
\title{warn or stop with invalid ICD-9 codes}
\usage{
stopIfInvalidIcd9(icd9, isShort)

warnIfInvalidIcd9(icd9, isShort)
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{isShort}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}
}
\description{
In the case of warning, execution continues, and the logical
  vector containing the *invalid* codes is returned invisibly. Returning the
  invalids for consistency with the name of the function. The warn version of
  this function only uses one call to check validity, making execution as
  fast as possible.
}
\seealso{
Other ICD9 validation: \code{\link{icd9GetInvalidMappingDecimal}},
  \code{\link{icd9GetInvalidMappingShort}},
  \code{\link{icd9ValidMapping}},
  \code{\link{icd9ValidMappingDecimal}},
  \code{\link{icd9ValidMappingShort}};
  \code{\link{icd9ValidDecimal}},
  \code{\link{icd9ValidDecimalE}},
  \code{\link{icd9ValidDecimalN}},
  \code{\link{icd9ValidDecimalV}};
  \code{\link{icd9ValidMajor}},
  \code{\link{icd9ValidMajorE}},
  \code{\link{icd9ValidMajorN}},
  \code{\link{icd9ValidMajorV}};
  \code{\link{icd9ValidNaWarnStop}},
  \code{\link{icd9ValidNaWarnStopDecimal}},
  \code{\link{icd9ValidNaWarnStopMajor}},
  \code{\link{icd9ValidNaWarnStopShort}};
  \code{\link{icd9ValidShort}},
  \code{\link{icd9ValidShortE}},
  \code{\link{icd9ValidShortN}},
  \code{\link{icd9ValidShortV}}; \code{\link{icd9Valid}}
}
\keyword{error}

