% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ValidShort}
\alias{icd9ValidShort}
\alias{icd9ValidShortE}
\alias{icd9ValidShortN}
\alias{icd9ValidShortV}
\title{validate ICD-9 short form code}
\usage{
icd9ValidShort(icd9Short)

icd9ValidShortV(icd9Short)

icd9ValidShortE(icd9Short)

icd9ValidShortN(icd9Short)
}
\arguments{
\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}
}
\value{
logical vector with T or F for each icd9 code provided according to
  validity
}
\description{
As in \code{icd9ValidDecimal}, character type of the
  input is enforced. An integer 100 could correspond to decimal ICD-9 codes
  1.00 10.0 or 100.
}
\seealso{
\url{http://www.stata.com/users/wgould/icd9/icd9.hlp}
  \url{http://www.sascommunity.org/wiki/Validate_the_format_of_ICD-9_codes}

Other ICD9 validation: \code{\link{icd9ValidDecimal}},
  \code{\link{icd9ValidDecimalE}},
  \code{\link{icd9ValidDecimalE}},
  \code{\link{icd9ValidDecimalN}},
  \code{\link{icd9ValidDecimalN}},
  \code{\link{icd9ValidDecimalV}},
  \code{\link{icd9ValidDecimalV}};
  \code{\link{stopIfInvalidIcd9}},
  \code{\link{warnIfInvalidIcd9}}
}

