% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{long_to_wide}
\alias{long_to_wide}
\title{Convert ICD data from long to wide format}
\usage{
long_to_wide(
  x,
  visit_name = get_visit_name(x),
  icd_name = get_icd_name(x),
  prefix = "icd_",
  min_width = 1L
)
}
\arguments{
\item{x}{data.frame of long-form data, one column for visit_name and one for
ICD code}

\item{visit_name}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visit_id}
was not specified, then the first column of the data frame is used.}

\item{icd_name}{The name of the column in the \code{data.frame} which
contains the ICD codes. This is a character vector of length one. If it is
\code{NULL}, \code{icd9} will attempt to guess the column name, looking for
progressively less likely possibilities until it matches a single column.
Failing this, it will take the first column in the data frame. Specifying
the column using this argument avoids the guesswork.}

\item{prefix}{character, default \code{icd_} to prefix new columns}

\item{min_width, }{single integer, if specified, writes out this many columns
even if no patients have that many codes. Must be greater than or equal to
the maximum number of codes per patient.}
}
\description{
Convert ICD data from long to wide format

Note the distinction between labelling existing data with any classes which
\code{icd} provides, and actually converting the structure of the data.
}
\details{
This is more complicated than expected using \code{base::reshape} or
  \code{reshape2::dcast} allows. This is a reasonably simple solution using
  built-in functions.
}
\section{Long and Wide Formats}{
 As is common with many data sets, key
  variables can be concentrated in one column or spread over several. Tools
  format of clinical and administrative hospital data, we can perform the
  conversion efficiently and accurately, while keeping some metadata about
  the codes intact, e.g. whether they are ICD-9 or ICD-10.
}

\section{Data structure}{
 Long or wide format ICD data are all expected to be
  in a data frame. The \code{data.frame} itself does not carry any ICD
  classes at the top level, even if it only contains one type of code;
  whereas its constituent columns may have a class specified, e.g.
  \code{icd9} or \code{icd10who}.
}

\examples{
longdf <- data.frame(
  visit_name = c("a", "b", "b", "c"),
  icd9 = c("441", "4424", "443", "441")
)
long_to_wide(longdf)
long_to_wide(longdf, prefix = "ICD10_")
}
\seealso{
Other ICD data conversion: 
\code{\link{comorbid_df_to_mat}()},
\code{\link{comorbid_mat_to_df}()},
\code{\link{convert}},
\code{\link{decimal_to_short}()},
\code{\link{short_to_decimal}()},
\code{\link{wide_to_long}()}
}
\concept{ICD data conversion}
