% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges.R, R/z-deprecated.R
\name{expand_range}
\alias{expand_range}
\alias{expand_range.character}
\alias{expand_range.icd9}
\alias{icd9_expand_range_short}
\alias{icd9_expand_range_decimal}
\alias{\%i9da\%}
\alias{\%i9sa\%}
\alias{\%i9d\%}
\alias{\%i9mj\%}
\alias{\%i9s\%}
\alias{icd_expand_range.character}
\alias{icd_expand_range.icd10cm}
\alias{icd_expand_range.icd9}
\alias{icd_expand_range_major.icd9}
\alias{icd_expand_range}
\title{take two ICD-9 codes and expand range to include all child codes}
\usage{
expand_range(start, end, ...)

\method{expand_range}{character}(start, end, short_code = NULL,
  defined = TRUE, ...)

\method{expand_range}{icd9}(start, end, short_code = guess_short(c(start,
  end)), defined = TRUE, ex_ambig_start = TRUE, ex_ambig_end = TRUE, ...)

icd9_expand_range_short(start, end, defined = TRUE, ex_ambig_start = TRUE,
  ex_ambig_end = TRUE)

icd9_expand_range_decimal(start, end, defined = TRUE, ex_ambig_start = TRUE,
  ex_ambig_end = TRUE)

start \%i9da\% end

start \%i9sa\% end

start \%i9d\% end

start \%i9mj\% end

start \%i9s\% end

icd_expand_range.character(...)

icd_expand_range.icd10cm(...)

icd_expand_range.icd9(...)

icd_expand_range_major.icd9(...)

icd_expand_range(...)
}
\arguments{
\item{start, end}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{...}{arguments passed on to other functions}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{ex_ambig_start}{single logical value, if \code{TRUE} the range returned
will not include codes which are explicitly listed in the range, but would
imply a broader range than specified. E.g. \code{V10 \%i9sa\% V1009} would
by default (\code{FALSE}) include \code{V10} even though \code{V10} itself
is parent to everything up to \code{V11}.}

\item{ex_ambig_end}{single logical, same as \code{ex_ambig_start} but affects
codes at the end of the range. E.g. 99.99 to 101.01 would by default
exclude 101 and 101.0}

\item{onlyReal}{single logical value, if \code{TRUE}, will limit the search
to those codes which appear in the master list, not just syntactically
valid codes. Since nearly valid, out-dated or new codes may be missed, not
limiting to officially defined values will be useful. Ultimately, there
will need to be annual (and all-time) master lists of codes and the ability
to test against a given master list given the year of the ICD-9 coding.}
}
\description{
this is cumbersome code, covering a whole load of edge cases relating to the
fact that ICD-9 codes are \strong{not} in numeric order. An alternative
strategy would be to list all the ICD9 codes, then a range would just pick
out start and finish positions, and return subset of the list. Not all ICD-9
codes are valid, including some parent codes which have valid children.
However, I expect at least some of these have been used in some billing
databases.
}
\details{
As with \code{link{icd9ExpandRangeShort}} great care is taken not to include
codes which have children not in the range. E.g. "100.9" to "101.1" would
_not_ include code "101".

\code{onlyReal} default is \code{TRUE} (a change from previous versions)
since this is far more likely to be useful to the end user.

When the class is not known, it must be guessed from the start and
  end codes. If this guessing fails, e.g. start is ICD-9 whereas end is
  ICD-10, then an error is thrown. Otherwise, the appropriate S3 method is
  called.

Expand range of short_code-form ICD-9 codes
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Expand a range of ICD-9 or ICD-10 codes when the
class is not known

\item \code{icd9}: Expand a range of ICD-9 codes
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\examples{
"4280" \%i9s\% "4289"
"4280" \%i9s\% "42821"
"42799" \%i9sa\% "42802" # doesn't include 428 or 4280
"427.99" \%i9da\% "428.02"
"V80" \%i9s\% "V810"
}
\seealso{
Other ICD-9 ranges: \code{\link{children}},
  \code{\link{condense}}, \code{\link{expand_minor}}
}
\keyword{internal}
