% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comorbid.R
\name{apply_hier}
\alias{apply_hier}
\alias{apply_hier_ahrq}
\alias{apply_hier_elix}
\alias{apply_hier_quan_deyo}
\alias{apply_hier_quan_elix}
\title{Apply hierarchy and choose naming for each comorbidity map}
\usage{
apply_hier_elix(x, abbrev_names = TRUE, hierarchy = TRUE)

apply_hier_quan_elix(cbd, abbrev_names = TRUE, hierarchy = TRUE)

apply_hier_quan_deyo(cbd, abbrev_names = TRUE, hierarchy = TRUE)

apply_hier_ahrq(cbd, abbrev_names = TRUE, hierarchy = TRUE)
}
\arguments{
\item{x}{matrix or data.frame of comorbidities}

\item{abbrev_names}{single logical value that defaults to \code{TRUE}, in
which case the shorter human-readable names stored in e.g.
\code{ahrqComorbidNamesAbbrev} are applied to the data frame column names.}

\item{hierarchy}{single logical value that defaults to \code{TRUE}, in which
case the hierarchy defined for the mapping is applied. E.g. in Elixhauser,
you can't have uncomplicated and complicated diabetes both flagged.}
}
\description{
Re-used by ICD-9 and ICD-10 versions which have the same rules.
}
\details{
For Deyo's Charlson comorbidities, strictly speaking, there is no
  dropping of more e.g. uncomplicated \code{DM} if complicated \code{DM}
  exists, however, this is probably useful, in general and is essential when
  calculating the Charlson score.
}
\keyword{internal}
\keyword{manip}

