% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_utils.R
\name{convertPos}
\alias{convertPos}
\title{Conversion of genetic map positions}
\usage{
convertPos(Mb = NULL, cM = NULL, map)
}
\arguments{
\item{Mb}{A vector of physical positions (in Mb), or NULL.}

\item{cM}{A vector of genetic positions (in cM), or NULL.}

\item{map}{A data frame with columns \code{Mb} and \code{cM}.}
}
\value{
A vector of the same length as the input.
}
\description{
Convert between physical position (in megabases) and genetic position
(centiMorgan) given a chromosome map. Linear extrapolation is used to convert
positions between map points.
}
\examples{
# Chromosome 1 of the built-in recombination map
map = loadMap(chrom = 1)[[1]]
head(map$male)

# Conversion Mb -> cM
phys = 1:5
gen = convertPos(Mb = phys, map = map$male)
gen

# Convert back (note the first position, which was outside of map)
convertPos(cM = gen, map = map$male)

}
