% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_sbm.R
\name{sample_correlated_sbm_pair}
\alias{sample_correlated_sbm_pair}
\alias{sample_correlated_sbm_pair_w_junk}
\title{Sample graphs pair from stochastic block model}
\usage{
sample_correlated_sbm_pair(
  n,
  pref.matrix,
  block.sizes,
  rho,
  permutation = 1:n,
  ...
)

sample_correlated_sbm_pair_w_junk(
  n,
  pref.matrix,
  block.sizes,
  rho,
  core.block.sizes,
  permutation = 1:n,
  ...
)
}
\arguments{
\item{n}{An integer. Number of vertices in the graph.}

\item{pref.matrix}{The matrix giving the Bernoulli rates. This is a \code{K-by-K} matrix, where
\code{k} is the number of groups. The probability of creating an edge between vertices from groups
\code{i} and \code{j} is given by element \code{i,j}. For undirected graphs, this matrix must be
symmetric.}

\item{block.sizes}{A numeric vector. Give the number of vertices in each group. The sum of the
vector must match the number of vertices.}

\item{rho}{A number. The target Pearson correlation between the adjacency matrices of the generated
graphs. It must be in open (0,1) interval.}

\item{permutation}{A numeric vector, permute second graph.}

\item{...}{Passed to \code{sample_correlated_sbm_pair} and \code{sample_correlated_sbm_pair_w_junk}.}

\item{core.block.sizes}{A numeric vector. Give the number of core vertices in each group. Entries
should be smaller than \code{block.sizes} and the vector length should be the same as \code{block.sizes}.}
}
\value{
A list of two 'igraph' object, named \code{graph1} and \code{graph2}.
}
\description{
Sample a pair of random graphs from stochastic block model with correlation between
two graphs being \code{rho} and edge probability being \code{p}.
}
\examples{
pm <- cbind( c(.1, .001), c(.001, .05) )
sample_correlated_sbm_pair(1000, pref.matrix=pm, block.sizes=c(300,700), rho=0.5)
sample_correlated_sbm_pair_w_junk(1000, pref.matrix=pm, block.sizes=c(300,700), rho=0.5,
core.block.sizes=c(200,500))
}
