% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_ieg.R
\name{sample_correlated_ieg_pair}
\alias{sample_correlated_ieg_pair}
\alias{sample_correlated_rdpg}
\title{Sample graphs from edge probability matrix and correlation matrix}
\usage{
sample_correlated_ieg_pair(
  n,
  p_mat,
  c_mat,
  directed = FALSE,
  loops = FALSE,
  permutation = 1:n
)

sample_correlated_rdpg(X, rho, nc = nrow(X), ...)
}
\arguments{
\item{n}{An integer. Number of total vertices for the sampled graphs.}

\item{p_mat}{An \code{n-by-n} matrix. Edge probability matrix, each entry
should be in the open (0,1) interval.}

\item{c_mat}{An \code{n-by-n} matrix. The target Pearson correlation matrix,
each entry should be in the open (0,1) interval.}

\item{directed}{Logical scalar, whether to generate directed graphs.}

\item{loops}{Logical scalar, whether self-loops are allowed in the graph.}

\item{permutation}{A numeric vector,permute second graph.}

\item{X}{A matrix. Dot products matrix, each entry must be in open (0,1)
interval.}

\item{rho}{A number. The target Pearson correlation between the adjacency
matrices of the generated graphs. It must be in open (0,1) interval.}

\item{nc}{An integer. Number of core vertices.}

\item{...}{Passed to \code{sample_correlated_rdpg_pair}.}
}
\value{
\code{sample_correlated_ieg_pair} returns two 'igraph' objects named
\code{graph1} and \code{graph2}.

\code{sample_correlated_rdpg} returns two 'igraph' objects named
\code{graph1} and \code{graph2} that are sampled from random dot product
graphs model.
}
\description{
Sample a pair of graphs with specified edge probability and
correlation between each pair of vertices.
}
\examples{
n <- 50
p_mat <- matrix(runif(n^2),n)
c_mat <- matrix(runif(n^2),n)
sample_correlated_ieg_pair(n,p_mat,c_mat)

## sample a pair of igraph objects from random dot
## product graphs model with dimension 3 and scale 8
n <- 50
xdim <- 3
scale <- 8
X <- matrix(rgamma(n*(xdim+1),scale,1),n,xdim+1)
X <- X/rowSums(X)
X <- X[,1:xdim]
sample_correlated_rdpg(X,rho=0.5)

}
