% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_report.R
\name{match_plot_igraph}
\alias{match_plot_igraph}
\alias{match_plot_matrix}
\title{Plotting methods for visualizing matches}
\usage{
match_plot_igraph(A, B, match, color = TRUE, linetype = TRUE, ...)

match_plot_matrix(
  A,
  B,
  match,
  col.regions = NULL,
  at = NULL,
  colorkey = NULL,
  ...
)
}
\arguments{
\item{A}{First graph. For \code{match_plot_igraph}
must be an 'igraph' object.}

\item{B}{First graph. For \code{match_plot_igraph}
must be an 'igraph' object.}

\item{match}{result from a match call. Requires element
\code{corr} as a data.frame with names corr_A, corr_B.}

\item{color}{Whether to color edges according to which
graph(s) they are in.}

\item{linetype}{Whether to set edge linetypes according
to which graph(s) they are in.}

\item{...}{additional parameters passed to either the
'igraph' plot function or the Matrix image function.}

\item{col.regions}{NULL for default colors, otherwise see \link[Matrix]{image-methods}}

\item{at}{NULL for default at values for at (ensures zero is grey), otherwise see \link[Matrix]{image-methods}}

\item{colorkey}{NULL for default colorkey, otherwise see \link[Matrix]{image-methods}}
}
\value{
Both functions return values invisibly.
\code{match_plot_igraph} returns the union of the
 matched graphs as an 'igraph' object with additional
 edge attributes \code{edge_match, color, lty}.
 \code{match_plot_matrix} returns the difference between
 the matched graphs.
}
\description{
Two functions are provided, \code{match_plot_igraph}
which makes a ball and stick plot from 'igraph' objects
and \code{match_plot_matrix} which shows an adjacency
matrix plot.
}
\details{
Grey edges/pixels indicate common edges, red
indicates edges only in graph A and green
represents edges only graph B. The corresponding
linetypes are solid, short dash, and long dash.

The plots can be recreated from the output with the code \cr
\code{plot(g)} \cr
for \code{g <- match_plot_igraph(...)} and  \cr
\code{col <- colorRampPalette(c("#AA4444", "#888888", "#44AA44"))} \cr
\code{image(m, col.regions = col(256))} \cr
for \code{m <- match_plot_match(...)}.

This only plots and returns the matched vertices.
}
\examples{
set.seed(123)
graphs <- sample_correlated_gnp_pair(20, .5, .3)
A <- graphs$graph1
B <- graphs$graph2
res <- graph_match_percolation(A, B, 1:4)

match_plot_igraph(A, B, res)
match_plot_matrix(A, B, res)
}
