% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_func.R
\name{row_cor}
\alias{row_cor}
\alias{row_diff}
\alias{row_perm_stat}
\title{Measure functions}
\usage{
row_cor(g1, g2)

row_diff(g1, g2)

row_perm_stat(g1, g2, exact = TRUE)
}
\arguments{
\item{g1}{A matrix or an 'igraph' object. Adjacency matrix of \eqn{G_1}.}

\item{g2}{A matrix or an 'igraph' object. Adjacency matrix of \eqn{G_2} after adjusting rows and columns
according to the correlation of matching between two graphs.}

\item{exact}{A logical. If \code{g1} and \code{g2} are binary, then set \code{exact=TRUE},
if \code{g1} and \code{g2} are weighted graphs, then set \code{exact=FALSE}.}
}
\value{
\code{row_cor} returns a vector, each element is 1 minus the row correlation value for
the corresponding vertex.

\code{row_diff} returns a vector, each element is the row difference value for
the corresponding vertex.

\code{row_perm_stat} returns a vector, each element is the row permutation statistics
value for the corresponding vertex.
}
\description{
Measures for computing the goodness of matching for each vertex.
}
\examples{
cgnp_pair <- sample_correlated_gnp_pair(n = 50, corr =  0.3,p =  0.5)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2
match <- graph_match_FW(g1, g2)
g2m <- g2[match$corr$corr_B, match$corr$corr_B]
g1 <- g1[]
row_cor(g1, g2m)
row_diff(g1, g2m)
row_perm_stat(g1, g2m)
}
