% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_convex.R, R/gm_indefinite.R, R/gm_path.R
\name{graph_match_convex}
\alias{graph_match_convex}
\alias{graph_match_FW}
\alias{gm_indefinite}
\alias{graph_match_PATH}
\title{Frank-Wolfe Graph Matching Methods}
\usage{
graph_match_convex(
  A,
  B,
  seeds = NULL,
  similarity = NULL,
  start = "bari",
  max_iter = 100,
  tol = 1e-05,
  lap_method = NULL
)

graph_match_FW(
  A,
  B,
  seeds = NULL,
  similarity = NULL,
  start = "bari",
  max_iter = 20,
  lap_method = NULL
)

gm_indefinite(
  A,
  B,
  seeds = NULL,
  similarity = NULL,
  start = "bari",
  max_iter = 20,
  lap_method = NULL
)

graph_match_PATH(
  A,
  B,
  seeds = NULL,
  similarity = NULL,
  epsilon = 1,
  tol = 1e-05,
  max_iter = 20,
  lap_method = NULL
)
}
\arguments{
\item{A}{A matrix, 'igraph' object, or list of either.}

\item{B}{A matrix, 'igraph' object, or list of either.}

\item{seeds}{A vector of integers or logicals, a matrix or a data frame. If
the seed pairs have the same indices in both graphs then seeds can be a
vector. If not, seeds must be  a matrix or a data frame, with the first
column being the indices of \eqn{G_1} and the second column being the
corresponding indices of \eqn{G_2}.}

\item{similarity}{A matrix. An \code{n-by-n} matrix containing vertex similaities.}

\item{start}{A matrix or a character. Any \code{nns-by-nns} matrix or
character value like "bari" or "convex" to initialize the starting matrix.}

\item{max_iter}{A number. Maximum number of replacing matches equals to
max_iter times number of total vertices of \eqn{G_1}.}

\item{tol}{A number. Tolerance of edge disagreements.}

\item{lap_method}{Choice for lap method.}

\item{epsilon}{A small number}
}
\value{
\code{graph_match_FW}, \code{graph_match_convex} and \code{graph_match
  _PATH} return a list of graph matching results, including the graph matching
  formula, a data frame containing the matching correspondence between \eqn{G_1}
  and \eqn{G_2} named \code{corr_A} and \code{corr_B}, the doubly stochastic
  matrix from the last iteration and the permutation matrix after projection,
  seeds and number of iterations.
}
\description{
Match two given graphs, returns a list of graph matching
  results, including matching correspondence vector of \eqn{G_2} with respect
  to \eqn{G_1}, doubly stochastic matrix and permutation matrix.
}
\examples{
cgnp_pair <- sample_correlated_gnp_pair(n = 10, corr =  0.3, p =  0.5)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2
# match G_1 & G_2 with no seeds
graph_match_FW(g1, g2)
seeds <- 1:10 <= 3
\donttest{
graph_match_convex(g1, g2, seeds)
}


# match G_1 & G_2 with some known node pairs as seeds
seeds <- 1:10 <= 3
graph_match_FW(g1, g2, seeds, start = "bari")

# match G_1 & G_2 with some incorrect seeds
hard_seeds <- matrix(c(4,6,5,4),2)
seeds <- rbind(as.matrix(check_seeds(seeds, nv = 10)$seeds),hard_seeds)
graph_match_FW(g1, g2, seeds, start = "convex")

 gp_list <- replicate(3, sample_correlated_gnp_pair(20, .3, .5), simplify = FALSE)
 A <- lapply(gp_list, function(gp)gp[[1]])
 B <- lapply(gp_list, function(gp)gp[[2]])
 match <- graph_match_FW(A, B, seeds = 1:10, start = "bari", max_iter = 20)
 match$corr

# match G_1 & G_2 using PATH algorithm
graph_match_PATH(g1, g2)

}
\references{
M. Zaslavskiy, F. Bach and J. Vert (2009), \emph{A Path following
algorithm for the graph matching problem}. IEEE Trans Pattern Anal Mach Intell,
pages 2227-2242.
}
