% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_matches.R
\name{best_matches}
\alias{best_matches}
\title{Choose best matches}
\usage{
best_matches(A, B, match, measure, num)
}
\arguments{
\item{A}{A matrix, an 'igraph' object or a list of either. Adjacency matrix of \eqn{G_1}.}

\item{B}{A matrix, an 'igraph' object or a list of either. Adjacency matrix of \eqn{G_2}.}

\item{match}{Graph matching result see graph match methods.}

\item{measure}{A character. Measure for computing goodness of matching.}

\item{num}{An integer. Number of pairs of best matched vertices needed.}
}
\value{
\code{best_matches} returns a data frame with the indices of best matched vertices
in \eqn{G_1} named \code{A_best}, the indices of best matched vertices in \eqn{G_2} named
\code{B_best} and the values of measure for best matches.
}
\description{
Find a set of vertices pairs in the order of goodness of matching according to a
specified measure.
}
\examples{
cgnp_pair <- sample_correlated_gnp_pair(n = 50, corr =  0.3, p =  0.5)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2
seeds <- 1:50 <= 10
nonseeds <- !seeds
match <- graph_match_FW(g1, g2, seeds)

# Application: select best matched seeds from non seeds as new seeds, and do the
# graph matching iteratively to get higher matching accuracy
best_matches(A = g1, B = g2, match = match, measure = "row_perm_stat", num = 5)


}
