% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_methods.R
\name{icite_search}
\alias{icite_search}
\title{Query the iCite API using a search strategy}
\usage{
icite_search(year = NA, offset = NA, limit = NA)
}
\arguments{
\item{year}{character or numeric. The year whose data you would like}

\item{offset}{character. The minimum PMID you would like to
have returned}

\item{limit}{character. The maximum number of records you would
like returned. There is a maximum of 1000 for a single call.}
}
\value{
If the call runs without error, the output is a simple S3 object
}
\description{
\code{icite_search} returns the parsed results of a single call to the iCite API
}
\examples{
dat <- icite_search(year=2012, offset = 18008027, limit=10)
print(dat)
}
