% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F0043.R
\name{run.tsne}
\alias{run.tsne}
\title{Run tSNE on the Main Data. Barnes-Hut implementation of t-Distributed Stochastic Neighbor Embedding}
\usage{
run.tsne(
  x = NULL,
  clust.method = "base.mean.rank",
  top.rank = 500,
  gene.list = "character",
  add.3d = TRUE,
  initial_dims = 50,
  perplexity = 30,
  theta = 0.5,
  check_duplicates = TRUE,
  pca = TRUE,
  max_iter = 1000,
  verbose = FALSE,
  is_distance = FALSE,
  Y_init = NULL,
  pca_center = TRUE,
  pca_scale = FALSE,
  stop_lying_iter = ifelse(is.null(Y_init), 250L, 0L),
  mom_switch_iter = ifelse(is.null(Y_init), 250L, 0L),
  momentum = 0.5,
  final_momentum = 0.8,
  eta = 200,
  exaggeration_factor = 12
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{clust.method}{Choose from "base.mean.rank" or "gene.model", defult is "base.mean.rank".}

\item{top.rank}{A number taking the top genes ranked by base mean, defult = 500.}

\item{gene.list}{A list of genes to be used for tSNE analysis. If "clust.method" is set to "gene.model", defult = "my_model_genes.txt".}

\item{add.3d}{Add 3D tSNE as well, default = TRUE.}

\item{initial_dims}{integer; the number of dimensions that should be retained in the initial PCA step (default: 50)}

\item{perplexity}{numeric; Perplexity parameter}

\item{theta}{numeric; Speed/accuracy trade-off (increase for less accuracy), set to 0.0 for exact TSNE (default: 0.5)}

\item{check_duplicates}{logical; Checks whether duplicates are present. It is best to make sure there are no duplicates present and set this option to FALSE, especially for large datasets (default: TRUE)}

\item{pca}{logical; Whether an initial PCA step should be performed (default: TRUE)}

\item{max_iter}{integer; Number of iterations (default: 1000)}

\item{verbose}{logical; Whether progress updates should be messageed (default: FALSE)}

\item{is_distance}{logical; Indicate whether X is a distance matrix (experimental, default: FALSE)}

\item{Y_init}{matrix; Initial locations of the objects. If NULL, random initialization will be used (default: NULL). Note that when using this, the initial stage with exaggerated perplexity values and a larger momentum term will be skipped.}

\item{pca_center}{logical; Should data be centered before pca is applied? (default: TRUE)}

\item{pca_scale}{logical; Should data be scaled before pca is applied? (default: FALSE)}

\item{stop_lying_iter}{integer; Iteration after which the perplexities are no longer exaggerated (default: 250, except when Y_init is used, then 0)}

\item{mom_switch_iter}{integer; Iteration after which the final momentum is used (default: 250, except when Y_init is used, then 0)}

\item{momentum}{numeric; Momentum used in the first part of the optimization (default: 0.5)}

\item{final_momentum}{numeric; Momentum used in the final part of the optimization (default: 0.8)}

\item{eta}{numeric; Learning rate (default: 200.0)}

\item{exaggeration_factor}{numeric; Exaggeration factor used to multiply the P matrix in the first part of the optimization (default: 12.0)}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and runs tSNE on main data. Wrapper for the C++ implementation of Barnes-Hut t-Distributed Stochastic Neighbor Embedding. t-SNE is a method for constructing a low dimensional embedding of high-dimensional data, distances or similarities. Exact t-SNE can be computed by setting theta=0.0.
}
\examples{
demo.obj <- run.tsne(demo.obj, perplexity = 20)

head(demo.obj@tsne.data)

}
