% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iNet.R
\name{run.knetl}
\alias{run.knetl}
\title{iCellR KNN Network}
\usage{
run.knetl(
  x = NULL,
  dist.method = "euclidean",
  k = 400,
  data.type = "pca",
  dims = 1:20,
  joint = FALSE,
  col.by = "clusters",
  my.seed = 1,
  layout.2d = "layout_nicely",
  layout.3d = "layout_with_fr",
  add.3d = FALSE,
  dim.redux = "tsne",
  do.redux = TRUE,
  run.iclust = FALSE,
  return.graph = FALSE
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{dist.method}{the distance measure to be used to compute the dissimilarity matrix. This must be one of: "euclidean", "maximum", "mandatattan", "canberra", "binary", "minkowski" or "NULL". By default, distance="euclidean". If the distance is "NULL", the dissimilarity matrix (diss) should be given by the user. If distance is not "NULL", the dissimilarity matrix should be "NULL".}

\item{k}{KNN the higher the number the less sensitivity, default = 400.}

\item{data.type}{Choose between "tsne", "pca", "umap", default = "pca".}

\item{dims}{PCA dimentions to be use for clustering, default = 1:20.}

\item{joint}{Run in Combined or joint fashion as in CCCA and CPCA, default = FALSE.}

\item{col.by}{If return.graph is TRUE the choose the cluster colors.  Choose between "clusters", "conditions".}

\item{my.seed}{seed number, default = 1.}

\item{layout.2d}{Choose your 2D layout, default = "layout_nicely".}

\item{layout.3d}{Choose your 3D layout, default = "layout_with_fr".}

\item{add.3d}{Add 3D KNetL as well, default = FALSE.}

\item{dim.redux}{Choose between "tsne", "pca", "umap" to unpack the nodes, default = "umap".}

\item{do.redux}{Perform dim reudx for unpaking the nodes, default = TRUE.}

\item{run.iclust}{Perform clustering as well (nor recomanded), default = FALSE.}

\item{return.graph}{return igraph object, default = FALSE.}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and and runs kNet for dimensionality reduction.
}
