% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-method.R
\name{iCARH.params}
\alias{iCARH.params}
\title{Summarize and return model parameters}
\usage{
iCARH.params(
  fit,
  pars = c("theta", "alpha", "beta", "phi"),
  path.names = NULL,
  prob = 0.95,
  use_cache = TRUE,
  digits = 2,
  ...
)
}
\arguments{
\item{fit}{Object returned by iCARH.model}

\item{pars}{Parameters of interest ("theta","alpha","beta","phi"). All parameters by default.}

\item{path.names}{Specify pathway names.}

\item{prob}{Confidence level. Defaults to 0.95.}

\item{use_cache}{passed to stan summary method.}

\item{digits}{The number of significant digits for printing out the summary; 
defaults to 2. The effective sample size is always rounded to integers.}

\item{...}{not used currently}
}
\value{
contain summaries for all chains. Included in the summaries are means, standard deviations (Est.Error), effective sample sizes (Eff.Sample), and split Rhats. 
Monte Carlo standard errors (MC.Error) are also reported.
}
\description{
Group of functions to summarize and return model parameters of interest
}
\section{Functions}{
\itemize{
\item \code{iCARH.params}: Summary of model parameters
}}

\examples{
data.sim = iCARH.simulate(4, 10, 14, 8, 2, path.probs=0.3, Zgroupeff=c(0,4),
beta.val=c(1,-1,0.5, -0.5))
XX = data.sim$XX
Y = data.sim$Y
Z = data.sim$Z
pathways = data.sim$pathways
\donttest{
rstan_options(auto_write = TRUE)
options(mc.cores = 2)
fit = iCARH.model(XX, Y, Z, groups=rep(c(0,1), each=5), pathways, 
control = list(adapt_delta = 0.99, max_treedepth=10), iter = 2, chains = 2)
if(!is.null(fit))
iCARH.params(fit)}


}
