% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_zero_regression.R
\name{k_var_model}
\alias{k_var_model}
\title{Best subset selection for linear regression}
\usage{
k_var_model(
  X_train,
  y_train,
  X_test = NULL,
  y_test = NULL,
  k = 1,
  parallel = FALSE
)
}
\arguments{
\item{X_train}{The design matrix used during training.}

\item{y_train}{The response variable used during training.}

\item{X_test}{The design matrix used during testing. Default is \code{X_test = NULL} and full data will be used to train the best subset linear regression model.}

\item{y_test}{The response variable used during testing. Default is \code{y_test = NULL} and full data will be used to train the best subset linear regression model.}

\item{k}{The maximum number of predictors allowed in the model. For example, \code{k = 5} will produce the best model 5 predictors.}

\item{parallel}{Logical flag for parallelization. Default is \code{parallel = FALSE}.}
}
\value{
A list of outputs.
\item{models}{An \code{lm} object storing the best k-predictor linear model.}
\item{names}{The variable name of the best k predictors.}
\item{rmse_in}{In-sample RMSE of the model.}
\item{rmse_out}{Out-of-sample RMSE of the model.}
}
\description{
Best subset selection for linear regression
}
