% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe.dose.R
\name{safe.dose}
\alias{safe.dose}
\title{Identify safe/acceptable doses from stage 1 based on observed binary toxicity}
\usage{
safe.dose(dose, dose.tox, p1, p2, K, coh.size)
}
\arguments{
\item{dose}{number of doses to be tested (scalar)}

\item{dose.tox}{vector of true toxicities for each dose. Values range from 0 - 1.}

\item{p1}{toxicity under null (unsafe DLT rate). Values range from 0 - 1.}

\item{p2}{toxicity under alternative (safe DLT rate). Values range from 0 - 1; p1 > p2}

\item{K}{threshold for LR. Takes integer values: 1,2,...(recommended K=2)}

\item{coh.size}{cohort size (number of patients) per dose (Stage 1)}
}
\value{
List of the following objects:
\itemize{
\item alloc.safe - matrix of assignments only for acceptable doses 
(to be used in stage 2) and their corresponding toxicities
\item alloc.total - vector of all dose assignments from stage 1 
\item n1 - total number of subjects allocated in stage 1
}
}
\description{
Function \code{safe.dose()} distinguishes acceptable from unacceptable doses
}
\examples{
dose = 5                                      # Dose levels
dose.tox <- c(0.05, 0.10, 0.15, 0.20, 0.30)   # True toxicity per dose
p1 = 0.40                                     # Unacceptable DLT rate
p2 = 0.15                                     # Acceptable DLT rate
K = 2                                         # Likelihood-ratio (LR) threshold
coh.size = 3                                  # Assign 3 pts per dose in stage 1

safe.dose(dose = dose, dose.tox = dose.tox, p1 = p1, p2 = p2, K = K, coh.size = coh.size) 

}
