% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast_iARModels.R
\name{Forecast_iARModels}
\alias{Forecast_iARModels}
\title{Forecast from iAR package model's}
\usage{
Forecast_iARModels(
  phi,
  y,
  st,
  tAhead,
  model = "iAR",
  mu = NULL,
  phiI = NULL,
  nu = NULL,
  level = 95
)
}
\arguments{
\item{phi}{Autocorrelation coefficient estimated by the method specified.}

\item{y}{Array with the time series observations.}

\item{st}{Array with the observational times.}

\item{tAhead}{The time ahead for which the forecast is required.}

\item{model}{model to be used for the forecast. The default is to use the iAR model. Other models available are "iAR-T", "iAR-Gamma", "CiAR" and "BiAR".}

\item{mu}{Level parameter of the IAR-Gamma process. A positive value.}

\item{phiI}{Imaginary parameter of CIAR model or Cross-correlation parameter of BIAR model.}

\item{nu}{degrees of freedom parameter of iAR-T model.}

\item{level}{significance level for the confidence interval. The default value is 95.}
}
\value{
A dataframe with the following columns:
\itemize{
\item{tAhead}{ The time ahead used for the forecast.}
\item{forecast}{ Point forecast in the time ahead required.}
\item{stderror}{ Standard error of the forecast.}
\item{lowerCI}{ Lower limit of the confidence interval.}
\item{upperCI}{ Upper limit of the confidence interval.}
}
}
\description{
Forecast with any of the models available in the iAR package
}
\examples{
st <- gentime(n=200,lambda1=15,lambda2=2)
y  <- IARsample(phi=0.9,n=200,st=st)
model<-IARloglik(y=y$series,st=st)
phi=model$phi
forIAR<-IARforecast(phi=phi,y$series,st=st,tAhead=c(1.3),standardized=FALSE,zero.mean=FALSE)
forIAR
forIAR<-Forecast_iARModels(phi=phi,y=y$series,st=st,tAhead=c(1.3,2.6))
forIAR
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARforecast}}, \code{\link{IARgforecast}}, \code{\link{IARforecast}}, \code{\link{BIARforecast}}
}
