% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergate.R
\name{plot_gating_strategy}
\alias{plot_gating_strategy}
\title{plot_gating_strategy}
\usage{
plot_gating_strategy(gate, xp, gate_vector, level, highlight = "black",
  path = "./", ...)
}
\arguments{
\item{gate}{A hypergate object (produced by hypergate())}

\item{xp}{The expression matrix from which the 'gate' parameter originates}

\item{gate_vector}{Categorical data from which the 'gate' parameter originates}

\item{level}{Level of gate_vector identifying the population of interest}

\item{highlight}{color of the positive population when plotting}

\item{path}{Where png files will be produced}

\item{...}{passed to png}
}
\description{
Plot a hypergate return
}
\examples{
data(Samusik_01_subset)
xp=Samusik_01_subset$xp_src[,Samusik_01_subset$regular_channels]
gate_vector=Samusik_01_subset$labels
hg=hypergate(xp=xp,gate_vector=gate_vector,level=23,delta_add=0.01)
par(mfrow=c(1,ceiling(length(hg$active_channels)/2)))
plot_gating_strategy(gate=hg,xp=xp,gate_vector=gate_vector,level=23,highlight="red")
}
