% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperspec-class.R
\docType{class}
\name{hyperSpec-class}
\alias{hyperSpec-class}
\title{Class "hyperSpec"
This class handles hyperspectral data sets, i.e. spatially or time-resolved
spectra, or spectra with any other kind of information associated with the
spectra.}
\description{
The spectra can be data as obtained in XRF, UV/VIS, Fluorescence, AES, NIR,
IR, Raman, NMR, MS, etc.
}
\details{
More generally, any data that is recorded over a discretized variable, e.g.
absorbance = f (wavelength), stored as a vector of absorbance values for
discrete wavelengths is suitable.
}
\section{Slots}{

\describe{
\item{\code{wavelength}}{wavelengths (wavenumbers, frequencies, etc.) for each of the columns of the
spectra matrix}

\item{\code{data}}{the data (extra data and spectra matrix)}

\item{\code{label}}{expressions for column labels (incl. units). The label of the wavelength axis is in
the special element \code{.wavelength}.}

\item{\code{log}}{deprecated.}
}}

\note{
Please note that the logbook is now removed.
}
\examples{

showClass("hyperSpec")
\dontrun{vignette ("hyperspec")}
}
\seealso{
See the vignette "hyperspec" for an introduction to hyperSpec
  from a spectroscopic point of view.
}
\author{
C. Beleites
}
\keyword{classes}
