% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/read.txt.Witec.R
\name{scan.txt.Witec}
\alias{scan.txt.Witec}
\alias{scan.dat.Witec}
\alias{scan.txt.Witec.Graph}
\alias{read.txt.Witec}
\alias{read.dat.Witec}
\alias{read.txt.Witec.Graph}
\title{File Import Witec Raman}
\usage{
scan.txt.Witec(...)

scan.dat.Witec(...)

scan.txt.Witec.Graph(...)

read.txt.Witec(
  file = stop("filename or connection needed"),
  points.per.line = NULL,
  lines.per.image = NULL,
  type = c("single", "map"),
  hdr.label = FALSE,
  hdr.units = FALSE,
  encoding = "unknown",
  ...,
  quiet = TRUE
)

read.dat.Witec(
  filex = stop("filename or connection needed"),
  filey = sub("-x", "-y", filex),
  points.per.line = NULL,
  lines.per.image = NULL,
  type = c("single", "map"),
  encoding = "unknown",
  ...,
  quiet = hy.getOption("debuglevel") < 1L
)

read.txt.Witec.Graph(
  headerfile = stop("filename or connection needed"),
  filex = gsub("Header", "X-Axis", headerfile),
  filey = gsub("Header", "Y-Axis", headerfile),
  type = c("single", "map"),
  encoding = "unknown",
  ...,
  quiet = TRUE
)
}
\arguments{
\item{..., quiet}{handed to \code{\link[base]{scan}}}

\item{file}{filename or connection to ASCII file}

\item{points.per.line}{number of spectra in x direction of the map}

\item{lines.per.image}{number of spectra in y direction}

\item{type}{type of spectra: \code{single} for single spectra (including time series), \code{map} for imaging data.}

\item{hdr.label}{WITec Project exports the spectra names (contain information of map position or number of spectra) within the \code{file}.}

\item{hdr.units}{WITec Project exports the spectra units within the \code{file}.}

\item{encoding}{character encoding, see \code{\link[base]{readLines}}}

\item{filex}{filename wavelength axis file}

\item{filey}{filename intensity file}

\item{headerfile}{filename or connection to ASCII file with header information}
}
\value{
a hyperSpec object
}
\description{
Import Raman Spectra/Maps from Witec Instrument via ASCII files
}
\details{
\code{read.txt.Witec} reads Witec ASCII files where the first column gives the wavelength
axes and the other columns the spectra. \code{read.dat.Witec} reads Witec's ASCII exported data
which comes in separate files with x and y data.

Parameters \code{nwl} (automatically calculated now) and \code{remove.zerospc}
(use  \code{\link{hy.setOptions} (file.remove.emptyspc = TRUE)} instead) have
been deprecated and removed.
}
\seealso{
\code{vignette ("fileio")} for more information on file import and

\code{\link{options}} for details on options.
}
\author{
Claudia Beleites and Marcel Dahms
}
\keyword{internal}
