% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AE.R
\name{extract_AE}
\alias{extract_AE}
\title{Extract Associated Events}
\usage{
extract_AE(
  relation_path,
  events_path,
  settings_path,
  inputdec = ".",
  inputsep = ",",
  saveResults = FALSE,
  outdir = tempdir(),
  TimeFormat = "\%Y-\%m-\%d \%H:\%M",
  tz = "Etc/GMT-1"
)
}
\arguments{
\item{relation_path}{Character string containing the path of the file which
the relation file is to be read from with
\code{\link[utils:read.csv]{utils::read.csv()}}. The file must contain a
column \code{ID} that contains the gauging station ID's in the file have to be
in order of their location in downstream direction.}

\item{events_path}{Character string containing the path of the directory
where the event files corresponding to the `relation` file are located. Only
relevant files in this directory will be used, i.e., files that are related to
the `relation` file.}

\item{settings_path}{Character string containing the path of the file which
the settings file is to be read from with
\code{\link[utils:read.csv]{utils::read.csv()}}. The file must be in format
of the output of \code{\link[=peaktrace]{peaktrace()}}.}

\item{inputdec}{Character string for decimal points in input data.}

\item{inputsep}{Field separator character string for input data.}

\item{saveResults}{A logical. If \code{FALSE} (default), the generated plot
and the estimated settings are not saved. Otherwise the settings are written
to a csv file and the plot are saved as png.}

\item{outdir}{Character string naming a directory where the estimated
settings should be saved to.}

\item{TimeFormat}{Character string giving the date-time format of the
date-time column in the input data frame (default: "\%Y-\%m-\%d \%H:\%M").}

\item{tz}{Character string specifying the time zone to be used for the
conversion (default: "Etc/GMT-1").}
}
\value{
A data frame containing \dQuote{real} AEs (i.e., events where the relative
    difference in amplitude is within the cut points provided by the file
    in \code{settings_path}).
}
\description{
For given relation and event data return the
    associated events which comply with the conditions specified in
    the settings.
}
\examples{
relation_path <- system.file("testdata", "relation.csv", package = "hydroroute")
events_path <- system.file("testdata", "Events", package = "hydroroute")
settings_path <- system.file("testdata", "Q_event_2_AMP-LAG_settings.csv",
                                   package = "hydroroute")
real_AE <- extract_AE(relation_path, events_path, settings_path)
}
