% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigate_connected_paths.R
\name{get_partial_length}
\alias{get_partial_length}
\title{Get Partial Flowpath Length}
\usage{
get_partial_length(hydro_location, network = NULL, flowpath = NULL)
}
\arguments{
\item{hydro_location}{list containing a hydrologic locations with names
aggregate_id (reachcode) and aggregate_id_measure (reachcode measure).}

\item{network}{data.frame network compatible with \link{hydroloom_names}.}

\item{flowpath}{data.frame containing one flowpath that corresponds to the
\code{hydro_location}. Not required if \code{x} is provided. \code{x} is not required if
\code{flowpath} is provided.}
}
\value{
list containing \code{up} and \code{dn} elements with numeric length in
km.
}
\description{
Finds the upstream and downstream lengths along a given
flowline. Internally, the function
rescales the aggregate_id_measure to a id_measure and applies that
rescaled measure to the length of the flowline.
}
\examples{

x <- sf::read_sf(system.file("extdata", "walker.gpkg", package = "hydroloom"))

hydro_location <- list(comid = 5329339,
  reachcode = "18050005000078",
  reach_meas = 30)

(pl <- get_partial_length(hydro_location, x))

}
