% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moody.R
\name{moody}
\alias{moody}
\title{Creates a Moody diagram with optional manually added points}
\usage{
moody(Re = NULL, f = NULL)
}
\arguments{
\item{Re}{(optional) numeric vector that contains the Reynolds numbers of points to be
manually added}

\item{f}{(optional) numeric vector (same length as Re) that contains the Darcy-Weisbach
friction factors corresponding to the points to be manually added}
}
\value{
a Moody diagram, with the optional added (f,Re) points
}
\description{
This function plots a standard Moody diagram, and allows additional
points to be added by including arguments Re and f.
}
\examples{

# Draw canonical Moody diagram
moody()

# Draw Moody diagram plotting two additional points
Re = c(10000, 100000)
f = c(0.04, 0.03)
moody( Re = Re, f = f )

}
\author{
Ed Maurer
}
