% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hySAINT.R
\name{hySAINT}
\alias{hySAINT}
\title{Hybrid Genetic and Simulated Annealing Algorithm\cr}
\usage{
hySAINT(
  X,
  y,
  heredity = "Strong",
  r1,
  r2,
  sigma,
  interaction.ind = NULL,
  varind = NULL,
  numElite = 40,
  max.iter = 500,
  initial.temp = 1000,
  cooling.rate = 0.95,
  lambda = 10
)
}
\arguments{
\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} observations by \code{p} main effects.}

\item{y}{Response variable. A \code{n}-dimensional vector.}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{r1}{At most how many main effects do you want to include in your model?.
For high-dimensional data, \code{r1} cannot be larger than the number of screened main effects.}

\item{r2}{At most how many interaction effects do you want to include in your model?}

\item{sigma}{The standard deviation of the noise term. In practice, sigma is usually
unknown. Users can estimate sigma from function \code{selectiveInference::estimateSigma},
then use the output as the sigma value.}

\item{interaction.ind}{A two-column numeric matrix. Each row represents a unique
interaction pair, with the columns indicating the index numbers of the variables
involved in each interaction. Note that interaction.ind must be generated
outside of this function using \code{t(utils::combn(p,2))}. See Example section for
details.}

\item{varind}{A numeric vector that specifies the indices of variables to be extracted from \code{X}.}

\item{numElite}{Number of elite parents. Default is 40.}

\item{max.iter}{Maximum number of iterations. Default is 500.}

\item{initial.temp}{Initial temperature. Default is 1000.}

\item{cooling.rate}{A numeric value represents the speed at which the
temperature decreases. Default is 0.95.}

\item{lambda}{A numeric value defined by users. The number needs to satisfy the condition:
\eqn{\lambda\geq 5.1/log(2)}. Default is 10.}
}
\value{
An object with S3 class \code{"hySAINT"}.
\item{Final.variable.names}{Name of the selected effects.}
\item{Final.variable.idx}{Index of the selected effects.}
\item{Final.model.score}{Final Model ABC.}
\item{All.iter.score}{Best ABC scores from initial parents and all iterations. }
}
\description{
This is the main function of package hySAINT. It implements both genetic
algorithm and simulated annealing. The simulated annealing technique is
used within mutation operator.
}
\examples{
set.seed(0)
interaction.ind <- t(combn(10,2))
X <- matrix(rnorm(100*10,1,0.1), 100, 10)
epl <- rnorm(100,0,0.01)
y <- 1+X[,1]+X[,2]+X[,3]+X[,1]*X[,2]+X[,1]*X[,3]+epl
hySAINT(X, y, r1 = 5, r2 = 2, sigma = 0.01, interaction.ind = interaction.ind, max.iter = 5)
}
\seealso{
\code{\link{ABC}}, \code{\link{EVA}}, \code{\link{Initial}},
\code{\link{Crossover}}, \code{\link{Mutation}}
}
