% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{left_border}
\alias{left_border}
\alias{left_border<-}
\alias{set_left_border}
\alias{map_left_border}
\alias{right_border}
\alias{top_border}
\alias{bottom_border}
\alias{right_border<-}
\alias{top_border<-}
\alias{bottom_border<-}
\alias{set_right_border}
\alias{set_top_border}
\alias{set_bottom_border}
\alias{map_right_border}
\alias{map_top_border}
\alias{map_bottom_border}
\title{Borders}
\usage{
left_border(ht)
left_border(ht) <- value
set_left_border(ht, row, col, value, byrow = FALSE)
map_left_border(ht, row, col, fn)

right_border(ht)
right_border(ht) <- value
set_right_border(ht, row, col, value, byrow = FALSE)
map_right_border(ht, row, col, fn)

top_border(ht)
top_border(ht) <- value
set_top_border(ht, row, col, value, byrow = FALSE)
map_top_border(ht, row, col, fn)

bottom_border(ht)
bottom_border(ht) <- value
set_bottom_border(ht, row, col, value, byrow = FALSE)
map_bottom_border(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector or matrix giving border widths in points. Set to 0 for no border.

Set to \code{NA} to reset to the default, which is \code{0}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{left_border}, the \code{left_border} property.
For \code{set_left_border} and \code{map_left_border}, the modified huxtable.

Similarly for the other functions.
}
\description{
Functions to get or set the \emph{borders} property of huxtable cells.
}
\details{
Currently in LaTeX, all non-zero border widths on a given line must be the same, and vertical border widths
can only be present (if \code{value > 0}) or absent.
}
\section{Note}{

huxtable currently sets borders on specific cells. This can lead to surprising behaviour when
cells span multiple rows or columns: see the example. This behaviour may be improved in a future
release.
}

\examples{

left_border(jams) <-  1
left_border(jams)
jams

set_left_border(jams, 1)
set_left_border(jams,
      2:3, 1, 1)
map_left_border(jams,
      by_rows(1, 0))
# When cells span multiple rows:
ht <- tribble_hux(
  ~Col1,                   ~Col2,
  "Cell 1,1 spans 2 rows", "Cell 1,2",
  "Cell 2,1 is invisible", "Cell 2,2"
)

rowspan(ht)[1, 1] <- 2
ht

bottom_border(ht)[2, ] <- 1
bottom_border_color(ht)[2, ] <- 'red'

# Cell 1, 1 does not have a border set:
ht

# Fixed:
bottom_border(ht)[1, 1] <- 1
bottom_border_color(ht)[1, 1] <- 'red'
ht
}
\seealso{
\code{\link[=set_all_borders]{set_all_borders()}}
}
