% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-set-convenience.R
\name{merge_cells}
\alias{merge_cells}
\title{Merge a range of cells}
\usage{
merge_cells(ht, row, col)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details. Only the minimum and maximum
rows and columns are used.}

\item{col}{A column specifier.}
}
\value{
The \code{ht} object.
}
\description{
Merge a range of cells
}
\details{
\code{merge_cells(ht, c(min_row, max_row), c(min_col, max_col))} is equivalent to\preformatted{  colspan(ht)[min_row, min_col] <- max_col - min_col + 1
  rowspan(ht)[min_row, min_col] <- max_row - min_row + 1
}

There is no way to merge cells that do not form a rectangle, so e.g.
\code{merge_cells(ht, where(ht > 0))} will usually have unexpected results.
}
\examples{
ht <- hux(a = 1:3, b = 1:3)
ht <- set_all_borders(ht, 1)
merge_cells(ht, 1:2, 1:2)
}
