% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{font}
\alias{font}
\alias{font<-}
\alias{set_font}
\alias{font.huxtable}
\alias{font<-.huxtable}
\title{Get or Set Font}
\usage{
font(ht)
font(ht) <- value
set_font(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector of font names. NB that LaTeX and HTML use different font names. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{font}, the \code{font} attribute.
For \code{set_font}, the \code{ht} object.
}
\description{
Functions to get or set the font property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
font(ht) <-  'times'
font(ht)

}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{na_string}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
