% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp-status.R
\name{resp_status}
\alias{resp_status}
\alias{resp_status_desc}
\alias{resp_is_error}
\alias{resp_check_status}
\title{Extract HTTP status from response}
\usage{
resp_status(resp)

resp_status_desc(resp)

resp_is_error(resp)

resp_check_status(resp, info = NULL, error_call = caller_env())
}
\arguments{
\item{resp}{A httr2 \link{response} object, created by \code{\link[=req_perform]{req_perform()}}.}

\item{info}{A character vector of additional information to include in
the error message. Passed to \code{\link[rlang:abort]{rlang::abort()}}.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
\itemize{
\item \code{resp_status()} returns a scalar integer
\item \code{resp_status_desc()} returns a string
\item \code{resp_is_error()} returns \code{TRUE} or \code{FALSE}
\item \code{resp_check_status()} invisibly returns the response if it's ok;
otherwise it throws an error with class \verb{httr2_http_\{status\}}.
}
}
\description{
\itemize{
\item \code{resp_status()} retrieves the numeric HTTP status code
\item \code{resp_status_desc()} retrieves the brief textual description.
\item \code{resp_is_error()} returns \code{TRUE} if the status code represents an error
(i.e. a 4xx or 5xx status).
\item \code{resp_check_status()} turns HTTPs errors into R errors.
}

These functions are mostly for internal use because in most cases you
will only ever see a 200 response:
\itemize{
\item 1xx are handled internally by curl.
\item 3xx redirects are automatically followed. You will only see them if you
have deliberately suppressed redirects with
\code{req |> req_options(followlocation = FALSE)}.
\item 4xx client and 5xx server errors are automatically turned into R errors.
You can stop them from being turned into R errors with \code{\link[=req_error]{req_error()}},
e.g. \code{req |> req_error(is_error = ~ FALSE)}.
}
}
\examples{
# An HTTP status code you're unlikely to see in the wild:
resp <- response(418)
resp |> resp_is_error()
resp |> resp_status()
resp |> resp_status_desc()
}
