% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock-api.R
\name{buildMockURL}
\alias{buildMockURL}
\title{Convert a request to a mock file path}
\usage{
buildMockURL(req, method = "GET")
}
\arguments{
\item{req}{A \code{request} object, or a character "URL" to convert}

\item{method}{character HTTP method. If \code{req} is a 'request' object,
its request method will override this argument}
}
\value{
A file path and name, with .json extension. The file may or may not
exist: existence is not a concern of this function.
}
\description{
Requests are translated to mock file paths according to several rules that
incorporate the request method, URL, query parameters, and body.
}
\details{
First, the URL is modified in two ways in order to allow it to map to a
local file system. All mock files have the request protocol such as "http://"
removed from the URL, and they also have a file extension appended. In an
HTTP API, a "directory" itself is a resource,
so the extension allows distinguishing directories and files in the file
system. That is, a mocked \code{GET("http://example.com/api/")} may read a
"example.com/api.json" file, while
\code{GET("http://example.com/api/object1/")} reads "example.com/api/object1.json".

The extension also gives information on content type. Two extensions are
currently supported: (1) .json and (2) .R. JSON mocks can be stored in .json
files, and when they are loaded by \code{\link[=with_mock_API]{with_mock_API()}}, relevant request
metadata (headers, status code, etc.) are inferred. If your API doesn't
return JSON, or if you want to simulate requests with other behavior (201
Location response, or 400 Bad Request, for example), you can store full
\code{response} objects in .R files that \code{with_mock_API} will \code{source} to load.
Any request can be stored as a .R mock, but the .json mocks offer a
simplified, more readable alternative. (\code{\link[=capture_requests]{capture_requests()}} will record
simplified .json files where appropriate and .R mocks otherwise by default.)

Second, if the request URL contains a query string, it will be popped off,
hashed by \code{\link[digest:digest]{digest::digest()}}, and the first six characters appended to the
file being read. For example, \code{GET("api/object1/?a=1")} reads
"api/object1-b64371.json". Third, request bodies are similarly hashed and
appended. Finally, if a request method other than GET is used it will be
appended to the end of the end of the file name. For example,
\code{POST("api/object1/?a=1")} reads "api/object1-b64371-POST.json".

This function is exported so that other packages can construct similar mock
behaviors or override specific requests at a higher level than
\code{with_mock_API} mocks.
}
\seealso{
\code{\link[=with_mock_API]{with_mock_API()}} \code{\link[=capture_requests]{capture_requests()}}
}
