% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_model.R
\name{solve_model}
\alias{solve_model}
\title{Solve_model}
\usage{
solve_model(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  times = NULL,
  parameters = NULL,
  model = NULL,
  route = "oral",
  dosing = NULL,
  days = 10,
  tsteps = 4,
  initial.values = NULL,
  plots = F,
  monitor.vars = NULL,
  suppress.messages = F,
  species = "Human",
  output.units = "uM",
  method = "lsoda",
  rtol = 1e-08,
  atol = 1e-12,
  recalc.blood2plasma = F,
  recalc.clearance = F,
  adjusted.Funbound.plasma = T,
  minimum.Funbound.plasma = 1e-04,
  parameterize.arg.list = list(default.to.human = F, clint.pvalue.threshold = 0.05,
    restrictive.clearance = T, regression = T),
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{times}{Optional time sequence for specified number of days. Dosing
sequence begins at the beginning of times.}

\item{parameters}{List of chemical parameters, as output by 
parameterize_pbtk function. Overrides chem.name and chem.cas.}

\item{model}{Specified model to use in simulation: "pbtk", "3compartment",
"3compartmentss", "1compartment", "schmitt", ...}

\item{route}{String specification of route of exposure for simulation:
"oral", "iv", "inhalation", ...}

\item{dosing}{List of dosing metrics passed to solver for a given model,
which must at least include entries with names "initial.dose", 
"doses.per.day", "daily.dose", and "dosing.matrix". The "dosing.matrix" can 
be used for more precise dose regimen specification, and is a matrix
consisting of two columns or rows named "time" and "dose" which contain the
time and amount, in mg/kg BW, of each dose. If none of the namesake entries 
of the dosing list is set to a non-NULL value, solve_model uses a default
dose of 1 mg/kg BW along with the dose type (add/multiply) specified for 
a given route (e.g. add the dose to gut lumen for oral route)}

\item{days}{Simulated period. Default 10 days.}

\item{tsteps}{The number of time steps per hour. Default of 4.}

\item{initial.values}{Vector containing the initial concentrations or
amounts of the chemical in specified tissues with units corresponding to
output.units.  Defaults are zero.}

\item{plots}{Plots all outputs if true.}

\item{monitor.vars}{Which variables are returned as a function of time. 
Default values of NULL looks up variables specified in modelinfo_MODEL.R}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{species}{Species desired (models have been designed to be
parameterized for some subset of the following species: "Rat", "Rabbit", 
"Dog", "Mouse", or default "Human").}

\item{output.units}{Desired units (either "mg/L", "mg", "umol", or default
"uM").}

\item{method}{Method used by integrator (deSolve).}

\item{rtol}{Argument passed to integrator (deSolve).}

\item{atol}{Argument passed to integrator (deSolve).}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical
in the blood to plasma using the input parameters, calculated with
hematocrit, Funbound.plasma, and Krbc2pu.}

\item{recalc.clearance}{Recalculates the the hepatic clearance
(Clmetabolism) with new million.cells.per.gliver parameter.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with partition coefficients calculated with this value.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset)}

\item{parameterize.arg.list}{Additional parameterized passed to the model
parameterization function.}

\item{...}{Additional arguments passed to the integrator.}

\item{default.to.human}{Substitutes missing animal values with human values
if true (hepatic intrinsic clearance or fraction of unbound plasma).}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{restrictive.clearance}{Protein binding not taken into account (set to
1) in liver clearance if FALSE.}
}
\value{
A matrix of class deSolve with a column for time(in days), each
compartment, the area under the curve, and plasma concentration and a row
for each time point.
}
\description{
solve_model's arguments prepare an ode system for numerical solution over
time of the amounts or concentrations (uM) of chemical in the different
bodily compartments of a given available species (either "Rat", "Rabbit",
"Dog", "Mouse", or default "Human").
}
\details{
The minimal usage case requires input that includes a chemical identifier
(whether name, CAS number, or other chemical parameterization) and a model
system of interest ("pbtk", "3compartment", "3compartmentss", "1compartment",
"schmitt", ...).

The 'dosing' argument includes all parameters needed to describe exposure
in terms of route of administration, frequency, and quantity short of 
scenarios that require use of a more precise forcing function. If the dosing
argument's namesake entries are left NULL, solve_model defaults to a
single-time dose of 1 mg/kg BW according to the given dosing route and 
associated type (either add/multiply, e.g. typically adds dose to gut lumen 
when oral route is specified).

AUC is the area under the curve of the plasma concentration.

Model parameters are named according to the following convention:
\tabular{lrrrr}{
prefix \tab suffix \tab Meaning \tab units \cr
K \tab \tab Partition coefficient for tissue to free plasma \ tab unitless \cr
V \tab \tab Volume \tab L \cr
Q \tab \tab Flow \tab L/h \cr
k \tab \tab Rate \tab 1/h \cr
\tab c \tab Parameter is proportional to body weight \tab 1 / kg for volumes
and 1/kg^(3/4) for flows \cr}

When species is specified but chemical-specific in vitro data are not
available, the function uses the appropriate physiological data (volumes and
flows) but default.to.human = TRUE must be used to substitute human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.
}
\references{
Pearce, Robert G., et al. "Httk: R package for high-throughput
toxicokinetics." Journal of statistical software 79.4 (2017): 1.
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Solve}
