% Generated by roxygen2 (4.0.0): do not edit by hand
\name{htmlDependency}
\alias{htmlDependency}
\title{Define an HTML dependency}
\usage{
htmlDependency(name, version, src, meta = NULL, script = NULL,
  stylesheet = NULL, head = NULL)
}
\arguments{
\item{name}{Library name}

\item{version}{Library version}

\item{src}{Unnamed single-element character vector indicating the full path
of the library directory. Alternatively, a named character string with one
or more elements, indicating different places to find the library; see
Details.}

\item{meta}{Named list of meta tags to insert into document head}

\item{script}{Script(s) to include within the document head (should be
specified relative to the \code{path} parameter).}

\item{stylesheet}{Stylesheet(s) to include within the document (should be
specified relative to the \code{path} parameter).}

\item{head}{Arbitrary lines of HTML to insert into the document head}
}
\value{
An object that can be included in a list of dependencies passed to
  \code{\link{attachDependencies}}.
}
\description{
Define an HTML dependency (i.e. CSS and/or JavaScript bundled in a
directory). HTML dependencies make it possible to use libraries like jQuery,
Bootstrap, and d3 in a more composable and portable way than simply using
script, link, and style tags.
}
\details{
Each dependency can be located on the filesystem, at a relative or
  absolute URL, or both. The location types are indicated using the names of
  the \code{src} character vector: \code{file} for filesystem directory,
  \code{href} for URL. For example, a dependency that was both on disk and
  at a URL might use \code{src = c(file=filepath, href=url)}.
}
\seealso{
Use \code{\link{attachDependencies}} to associate a list of
  dependencies with the HTML it belongs with.
}

