% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimation.R
\name{bayes_R2.hsstan}
\alias{bayes_R2.hsstan}
\alias{bayes_R2}
\alias{loo_R2.hsstan}
\alias{loo_R2}
\title{Bayesian and LOO-adjusted R-squared}
\usage{
\method{bayes_R2}{hsstan}(object, prob = 0.95, summary = TRUE, ...)

\method{loo_R2}{hsstan}(object, prob = 0.95, summary = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{hsstan}.}

\item{prob}{Width of the posterior interval (0.95, by default). It is
ignored if \code{summary=FALSE}.}

\item{summary}{Whether a summary of the distribution of the R-squared
should be returned rather than the pointwise values (\code{TRUE} by
default).}

\item{...}{Currently ignored.}
}
\value{
The mean, standard deviation and posterior interval of R-squared if
\code{summary=TRUE}, or a vector of R-squared values with length equal to
the size of the posterior sample if \code{summary=FALSE}.
}
\description{
Compute the Bayesian and the LOO-adjusted R-squared from the posterior
samples. For Bayesian R-squared it uses the modelled residual variance
(rather than the variance of the posterior distribution of the residuals).
The LOO-adjusted R-squared uses Pareto smoothed importance sampling LOO
residuals and Bayesian bootstrap.
}
\examples{
\dontshow{utils::example("hsstan", echo=FALSE)}
\dontshow{oldopts <- options(mc.cores=2)}
# continued from ?hsstan
bayes_R2(hs.biom)
loo_R2(hs.biom)
\dontshow{options(oldopts)}

}
\references{
Andrew Gelman, Ben Goodrich, Jonah Gabry and Aki Vehtari (2019),
R-squared for Bayesian regression models,
\emph{The American Statistician}, 73 (3), 307-309.
\url{https://doi.org/10.1080/00031305.2018.1549100}

Aki Vehtari, Andrew Gelman, Ben Goodrich and Jonah Gabry (2019),
Bayesian R2 and LOO-R2.
\url{https://avehtari.github.io/bayes_R2/bayes_R2.html}
}
