% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/graphs.R
\name{get.hpo.graph}
\alias{get.hpo.graph}
\title{Get HPO graph object}
\usage{
get.hpo.graph(hpo.terms, terms = apply.term.filters(hpo.terms = hpo.terms,
  plotting.context = plotting.context, term.filters = list()),
  plotting.context = NULL, colours = get.white.nodes,
  labels = get.simple.node.labels, borders = get.grey.borders,
  sizes = get.standard.sizes, font.sizes = rep(30, length(terms)),
  shapes = rep("circle", length(terms)), nodeAttrs = NULL)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{terms}{Character vector of HPO terms}

\item{plotting.context}{List object with hpo.phenotypes slot for list of character vectors of terms}

\item{colours}{Function to set the colours of the HPO nodes in the graph based on the plotting context, or a character vector of colours}

\item{labels}{Function to set the labels of the HPO nodes in the graph based on the plotting context, or a character vector of node labels}

\item{borders}{Function to set the borders of the HPO nodes in the graph based on the plotting context, or a character vector of border colours}

\item{sizes}{Function to set the sizes of the HPO nodes in the graph based on the plotting context, or a numeric vector of node sizes}

\item{font.sizes}{Function to set the font sizes of the text to be placed in the HPO nodes in the graph based on the plotting context, or an integer vector of font sizes}

\item{shapes}{Function to set the shapes of the HPO nodes in the graph based on the plotting context, or a character vector of shape names (defaults to 'circle')}

\item{nodeAttrs}{Pass nodeAttrs directly to rgraphviz plotting function}
}
\value{
graphAM S4 object
}
\description{
Get HPO graph object
}
\examples{
data(hpo.terms)
phenotype.strings <- c(
	A="HP:0001382,HP:0004272,HP:0007917,HP:0004912,HP:0001596",
	B="HP:0001382,HP:0004272,HP:0002165,HP:0004800,HP:0004912",
	C="HP:0004800,HP:0001382,HP:0004912,HP:0007917,HP:0008743",
	D="HP:0001257,HP:0001382,HP:0007917,HP:0012623,HP:0002165",
	E="HP:0007917,HP:0004800,HP:0004272,HP:0001596,HP:0002165"
)

hpo.phenotypes <- term.set.list.from.character(phenotype.strings)

get.hpo.graph(
	hpo.terms=hpo.terms,
	plotting.context=list(hpo.phenotypes=hpo.phenotypes)
)
}
\seealso{
\code{\link{hpo.plot}}
}

