% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{tmr_print}
\alias{tmr_print}
\title{Print hms Timer}
\usage{
tmr_print(x)
}
\arguments{
\item{x}{A \code{\link[=hms_timer]{hms_timer()}}.}
}
\value{
A character string.
}
\description{
Returns the elapsed time for a \code{\link[=hms_timer]{hms_timer()}} from the system time when the
timer was started and the current system time as an hms time.
}
\details{
The elapsed time is the value of the scalar plus the difference
between the current system time and the system time when the timer was started.
}
\examples{
x <- tmr_start(tmr_timer())
tmr_print(x)
}
\seealso{
Other start_stop: 
\code{\link{tmr_elapsed}()},
\code{\link{tmr_is_started}()},
\code{\link{tmr_is_stopped}()},
\code{\link{tmr_reset}()},
\code{\link{tmr_start}()},
\code{\link{tmr_stop}()},
\code{\link{tmr_timer}()}
}
\concept{start_stop}
