% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.HMM}
\alias{update.HMM}
\title{Update a model to a new model by changing one formula}
\usage{
\method{update}{HMM}(object, type, i, j, change, fit = TRUE, silent = FALSE, ...)
}
\arguments{
\item{object}{HMM model object}

\item{type}{Character string for the part of the model that is updated
(either "hid" or "obs")}

\item{i}{If type = "hid" then i is the row of the formula containing the 
change. If type = "obs" then i is the observation variable name.}

\item{j}{If type = "hid" then j is the column of the formula containing the 
change. If type = "obs" then j is the parameter whose formula is to be 
changed.}

\item{change}{The change to make to the formula, see ?update.formula for 
details.}

\item{fit}{If FALSE then change is made but model is not re-fit.}

\item{silent}{If TRUE then no model fitting output is given}

\item{...}{Additional arguments are ignored (for compatibility with generic
S3 method)}
}
\description{
Update a model to a new model by changing one formula
}
\examples{
# Load data set from MSwM package
data(energy, package = "MSwM")

# Create hidden state and observation models
hid <- MarkovChain$new(data = energy, n_states = 2)
par0 <- list(Price = list(mean = c(3, 6), sd = c(2, 3)))
obs <- Observation$new(data = energy, n_states = 2,
                       dists = list(Price = "norm"),
                       par = par0)

# Create HMM (no covariate effects)
hmm <- HMM$new(hid = hid, obs = obs)
hmm$hid()$formula()
hmm$obs()$formulas()

# Update transition probability formulas (one at a time)
hmm <- update(hmm, type = "hid", i = 1, j = 2, 
              change = ~ . + Oil, fit = FALSE)
hmm <- update(hmm, type = "hid", i = 2, j = 1, 
              change = ~ . + Gas + Coal, fit = FALSE)
hmm$hid()$formula()

# Update observation parameter formulas (one at a time)
hmm <- update(hmm, type = "obs", i = "Price", j = "mean", 
              change = ~ . + EurDol, fit = FALSE)
hmm$obs()$formulas()
}
