% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{subset_emulators}
\alias{subset_emulators}
\title{Subsetting for Bimodal/Variance Emulators}
\usage{
subset_emulators(emulators, output_names)
}
\arguments{
\item{emulators}{A set of emulators, often in nested form}

\item{output_names}{The names of the desired outputs}
}
\value{
An object of the same form as `emulators`.
}
\description{
Takes a collection of bimodal or stochastic emulators and subsets by output name.
}
\details{
It can be useful to consider only a subset of outputs. In the normal case, this can be
easily achieved; however, when the emulators are in a nested structure such as that
provided by emulator_from_data with emulator_type = 'variance' or 'bimodal', it can
be more involved. This function allows the easy selecting of emulators by name, returning a
subset of them in the same form as the original object.

This function is compatible with `standard' emulators; that is, those in a simple
list, equivalent to subsetting over the collection of output names of the emulators
that exist in \code{output_names}.
}
