% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfun.R
\name{hmclearn-plots}
\alias{hmclearn-plots}
\alias{mcmc_intervals}
\alias{mcmc_intervals.hmclearn}
\alias{mcmc_areas}
\alias{mcmc_areas.hmclearn}
\alias{mcmc_hist}
\alias{mcmc_hist.hmclearn}
\alias{mcmc_hist_by_chain}
\alias{mcmc_hist_by_chain.hmclearn}
\alias{mcmc_dens}
\alias{mcmc_dens.hmclearn}
\alias{mcmc_scatter}
\alias{mcmc_scatter.hmclearn}
\alias{mcmc_hex}
\alias{mcmc_hex.hmclearn}
\alias{mcmc_pairs}
\alias{mcmc_pairs.hmclearn}
\alias{mcmc_acf}
\alias{mcmc_acf.hmclearn}
\alias{mcmc_acf_bar}
\alias{mcmc_acf_bar.hmclearn}
\alias{mcmc_trace}
\alias{mcmc_trace.hmclearn}
\alias{mcmc_rhat}
\alias{mcmc_rhat.hmclearn}
\alias{mcmc_rhat_hist}
\alias{mcmc_rhat_hist.hmclearn}
\alias{mcmc_neff}
\alias{mcmc_neff.hmclearn}
\alias{mcmc_neff_hist}
\alias{mcmc_neff_hist.hmclearn}
\alias{mcmc_neff_data}
\alias{mcmc_neff_data.hmclearn}
\alias{mcmc_violin}
\alias{mcmc_violin.hmclearn}
\title{Plotting for MCMC visualization and diagnostics provided by \code{bayesplot} package}
\usage{
mcmc_intervals(object, ...)

\method{mcmc_intervals}{hmclearn}(object, burnin = NULL, ...)

mcmc_areas(object, ...)

\method{mcmc_areas}{hmclearn}(object, burnin = NULL, ...)

mcmc_hist(object, ...)

\method{mcmc_hist}{hmclearn}(object, burnin = NULL, ...)

mcmc_hist_by_chain(object, ...)

\method{mcmc_hist_by_chain}{hmclearn}(object, burnin = NULL, ...)

mcmc_dens(object, ...)

\method{mcmc_dens}{hmclearn}(object, burnin = NULL, ...)

mcmc_scatter(object, ...)

\method{mcmc_scatter}{hmclearn}(object, burnin = NULL, ...)

mcmc_hex(object, ...)

\method{mcmc_hex}{hmclearn}(object, burnin = NULL, ...)

mcmc_pairs(object, ...)

\method{mcmc_pairs}{hmclearn}(object, burnin = NULL, ...)

mcmc_acf(object, ...)

\method{mcmc_acf}{hmclearn}(object, burnin = NULL, ...)

mcmc_acf_bar(object, ...)

\method{mcmc_acf_bar}{hmclearn}(object, burnin = NULL, ...)

mcmc_trace(object, ...)

\method{mcmc_trace}{hmclearn}(object, burnin = NULL, ...)

mcmc_rhat(object, ...)

\method{mcmc_rhat}{hmclearn}(object, burnin = NULL, ...)

mcmc_rhat_hist(object, ...)

\method{mcmc_rhat_hist}{hmclearn}(object, burnin = NULL, ...)

mcmc_neff(object, ...)

\method{mcmc_neff}{hmclearn}(object, burnin = NULL, lagmax = NULL, ...)

mcmc_neff_hist(object, ...)

\method{mcmc_neff_hist}{hmclearn}(object, burnin = NULL, lagmax = NULL, ...)

mcmc_neff_data(object, ...)

\method{mcmc_neff_data}{hmclearn}(object, burnin = NULL, lagmax = NULL, ...)

mcmc_violin(object, ...)

\method{mcmc_violin}{hmclearn}(object, burnin = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{hmclearn}, usually a result of a call to \code{mh} or \code{hmc}}

\item{...}{optional additional arguments to pass to the \code{bayesplot} functions}

\item{burnin}{optional numeric parameter for the number of initial MCMC samples to omit from the summary}

\item{lagmax}{maximum lag to extract for determining effective sample sizes}
}
\value{
These functions call various plotting functions from the \code{bayesplot} package, which returns a list including \code{ggplot2} objects.
}
\description{
Plots of Rhat statistics, ratios of effective sample size to total sample
size, and autocorrelation of MCMC draws.
}
\section{Plot Descriptions from the \code{bayesplot} package documentation}{

\describe{
  \item{`mcmc_hist(object, burnin=NULL, ...)`}{
   Default plot called by `plot` function.  Histograms of posterior draws with all chains merged.
  }
  \item{`mcmc_dens(object, burnin=NULL, ...)`}{
   Kernel density plots of posterior draws with all chains merged.
  }
  \item{`mcmc_hist_by_chain(object, burnin=NULL, ...)`}{
   Histograms of posterior draws with chains separated via faceting.
  }
  \item{`mcmc_dens_overlay(object, burnin=NULL, ...)`}{
   Kernel density plots of posterior draws with chains separated but
   overlaid on a single plot.
  }
  \item{`mcmc_violin(object, burnin=NULL, ...)`}{
   The density estimate of each chain is plotted as a violin with
   horizontal lines at notable quantiles.
  }
  \item{`mcmc_dens_chains(object, burnin=NULL, ...)`}{
   Ridgeline kernel density plots of posterior draws with chains separated
   but overlaid on a single plot. In `mcmc_dens_overlay()` parameters
   appear in separate facets; in `mcmc_dens_chains()` they appear in the
   same panel and can overlap vertically.
  }
  \item{`mcmc_intervals(object, burnin=NULL, ...)`}{
   Plots of uncertainty intervals computed from posterior draws with all
   chains merged.
  }
  \item{`mcmc_areas(object, burnin=NULL, ...)`}{
   Density plots computed from posterior draws with all chains merged,
   with uncertainty intervals shown as shaded areas under the curves.
  }
  \item{`mcmc_scatter(object, burnin=NULL, ...)`}{
   Bivariate scatterplot of posterior draws. If using a very large number of
   posterior draws then `mcmc_hex()` may be preferable to avoid
   overplotting.
  }
  \item{`mcmc_hex(object, burnin=NULL, ...)`}{
   Hexagonal heatmap of 2-D bin counts. This plot is useful in cases where
   the posterior sample size is large enough that `mcmc_scatter()` suffers
   from overplotting.
  }
  \item{`mcmc_pairs(object, burnin=NULL, ...)`}{
   A square plot matrix with univariate marginal distributions along the
   diagonal (as histograms or kernel density plots) and bivariate
   distributions off the diagonal (as scatterplots or hex heatmaps).

   For the off-diagonal plots, the default is to split the chains so that
   (roughly) half are displayed above the diagonal and half are below (all
   chains are always merged together for the plots along the diagonal). Other
   possibilities are available by setting the `condition` argument.
  }
\item{`mcmc_rhat(object, burnin=NULL, ...)`, `mcmc_rhat_hist(object, burnin=NULL, ...)`}{
  Rhat values as either points or a histogram. Values are colored using
  different shades (lighter is better). The chosen thresholds are somewhat
  arbitrary, but can be useful guidelines in practice.
  * _light_: below 1.05 (good)
  * _mid_: between 1.05 and 1.1 (ok)
  * _dark_: above 1.1 (too high)
 }
 \item{`mcmc_neff(object, burnin=NULL, ...)`, `mcmc_neff_hist(object, burnin=NULL, ...)`}{
  Ratios of effective sample size to total sample size as either points or a
  histogram. Values are colored using different shades (lighter is better).
  The chosen thresholds are somewhat arbitrary, but can be useful guidelines
  in practice.
  * _light_: between 0.5 and 1 (high)
  * _mid_: between 0.1 and 0.5 (good)
  * _dark_: below 0.1 (low)
 }
 \item{`mcmc_acf(object, burnin=NULL, ...)`, `mcmc_acf_bar(object, burnin=NULL, ...)`}{
  Grid of autocorrelation plots by chain and parameter. The `lags` argument
  gives the maximum number of lags at which to calculate the autocorrelation
  function. `mcmc_acf()` is a line plot whereas `mcmc_acf_bar()` is a
  barplot.
 }
}
}

\examples{
# poisson regression example
set.seed(7363)
X <- cbind(1, matrix(rnorm(40), ncol=2))
betavals <- c(0.8, -0.5, 1.1)
lmu <- X \%*\% betavals
y <- sapply(exp(lmu), FUN = rpois, n=1)

f <- hmc(N = 1000,
          theta.init = rep(0, 3),
          epsilon = c(0.03, 0.02, 0.015),
          L = 10,
          logPOSTERIOR = poisson_posterior,
          glogPOSTERIOR = g_poisson_posterior,
          varnames = paste0("beta", 0:2),
          param = list(y=y, X=X),
          parallel=FALSE, chains=2)

mcmc_trace(f, burnin=100)
mcmc_hist(f, burnin=100)
mcmc_intervals(f, burnin=100)
mcmc_rhat(f, burnin=100)
mcmc_violin(f, burnin=100)
}
\references{
Gabry, Jonah and Mahr, Tristan (2019).  \emph{bayesplot:  Plotting for Bayesian Models}.  \url{https://mc-stan.org/bayesplot}

Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., and Gelman, A (2019).  \emph{Visualization in Bayesian Workflow}.  Journal of the Royal Statistical Society: Series A. Vol 182.  Issue 2.  p.389-402.

Gelman, A. and Rubin, D. (1992) \emph{Inference from Iterative Simulation Using Multiple Sequences}.  Statistical Science 7(4) 457-472.

Gelman, A., et. al. (2013) \emph{Bayesian Data Analysis}.  Chapman and Hall/CRC.
}
