% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.hmclearn}
\alias{coef.hmclearn}
\title{Extract Model Coefficients}
\usage{
\method{coef}{hmclearn}(object, burnin = NULL, prob = 0.5, ...)
}
\arguments{
\item{object}{an object of class \code{hmclearn}, usually a result of a call to \code{mh} or \code{hmc}}

\item{burnin}{optional numeric parameter for the number of initial MCMC samples to omit from the summary}

\item{prob}{quantile to extract coefficients}

\item{...}{additional arguments to pass to \code{quantile}}
}
\value{
Numeric vector of parameter point estimates based on the given \code{prob}, with a default of the median estimate.
}
\description{
Method for \code{hmclearn} objects created by \code{mh} and \code{hmc} functions.  Extracts the specified quantile of the posterior.
}
\examples{
# Linear regression example
set.seed(521)
X <- cbind(1, matrix(rnorm(300), ncol=3))
betavals <- c(0.5, -1, 2, -3)
y <- X\%*\%betavals + rnorm(100, sd=.2)

f1 <- hmc(N = 500,
          theta.init = c(rep(0, 4), 1),
          epsilon = 0.01,
          L = 10,
          logPOSTERIOR = linear_posterior,
          glogPOSTERIOR = g_linear_posterior,
          varnames = c(paste0("beta", 0:3), "log_sigma_sq"),
          param=list(y=y, X=X), parallel=FALSE, chains=1)

summary(f1)
coef(f1)
}
