% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simDINA}
\alias{simDINA}
\title{Simulate DINA model responses (entire cube)}
\usage{
simDINA(alphas, itempars, ETA, Test_order, Test_versions)
}
\arguments{
\item{alphas}{An N-by-K-by-L \code{array} of attribute patterns of all persons across L time points}

\item{itempars}{A J-by-2-by-L \code{cube} of item parameters (slipping: 1st col, guessing: 2nd col) across item blocks}

\item{ETA}{A J-by-2^K-by-L \code{array} of ideal responses across all item blocks, with each slice generated with ETAmat function}

\item{Test_order}{A N_versions-by-L \code{matrix} indicating which block of items were administered to examinees with specific test version.}

\item{Test_versions}{A length N \code{vector} of the test version of each examinee}
}
\value{
An \code{array} of DINA item responses of examinees across all time points
}
\description{
Simulate a cube of DINA responses for all persons on items across all time points
}
\examples{
N = length(Test_versions)
J = nrow(Q_matrix)
K = ncol(Q_matrix)
L = nrow(Test_order)
Jt = J/L
itempars_true <- array(runif(Jt*2*L,.1,.2), dim = c(Jt,2,L))

ETAs <- ETAmat(K,J,Q_matrix)
class_0 <- sample(1:2^K, N, replace = L)
Alphas_0 <- matrix(0,N,K)
mu_thetatau = c(0,0)
Sig_thetatau = rbind(c(1.8^2,.4*.5*1.8),c(.4*.5*1.8,.25))
Z = matrix(rnorm(N*2),N,2)
thetatau_true = Z\%*\%chol(Sig_thetatau)
thetas_true = thetatau_true[,1]
taus_true = thetatau_true[,2]
G_version = 3
phi_true = 0.8
for(i in 1:N){
  Alphas_0[i,] <- inv_bijectionvector(K,(class_0[i]-1))
}
lambdas_true <- c(-2, .4, .055)
Q_examinee <- Q_list(Q_matrix, Test_order, Test_versions)     
Alphas <- simulate_alphas_HO_joint(lambdas_true,thetas_true,Alphas_0,Q_examinee,L,Jt)
Y_sim <- simDINA(Alphas,itempars_true,ETAs,Test_order,Test_versions)
}
